\name{sjp.emm.int}
\alias{sjp.emm.int}
\title{Plot adjusted (estimated marginal) means of interaction (moderation) in linear models}
\usage{
sjp.emm.int(fit, swapPredictors = FALSE, plevel = 0.05, title = NULL,
  titleSize = 1.3, titleColor = "black", lowerBoundColor = "#3366cc",
  upperBoundColor = "#cc3300", colorPalette = "Set2", axisTitle.x = NULL,
  axisTitle.y = NULL, axisLabelColor = "gray30", axisLabelSize = 1.1,
  axisTitleColor = "black", axisTitleSize = 1.3, legendLabels = NULL,
  legendLabelSize = 0.9, legendLabelColor = "black",
  showValueLabels = FALSE, valueLabel.digits = 2, valueLabelSize = 4,
  valueLabelColor = "black", valueLabelAlpha = 0.8, breakTitleAt = 50,
  breakLegendLabelsAt = 20, breakAnnotationLabelsAt = 50,
  axisLimits.y = NULL, gridBreaksAt = NULL, theme = NULL,
  showTickMarks = TRUE, borderColor = NULL, axisColor = NULL,
  majorGridColor = NULL, minorGridColor = NULL, hideGrid.x = FALSE,
  hideGrid.y = FALSE, printPlot = TRUE)
}
\arguments{
  \item{fit}{the fitted linear model (lm) object, including
  interaction terms}

  \item{swapPredictors}{if \code{TRUE}, the grouping
  variable and predictor on the x-axis are swapped.}

  \item{plevel}{Indicates at which p-value an interaction
  term is considered as significant. Default is 0.05 (5
  percent).}

  \item{title}{a default title used for the plots. Default
  value is \code{NULL}, which means that each plot's title
  includes the dependent variable as well as the names of
  the interaction terms.}

  \item{titleSize}{The size of the plot title. Default is
  1.3.}

  \item{titleColor}{The color of the plot title. Default is
  \code{"black"}.}

  \item{lowerBoundColor}{the color of the line indicating
  the lower bound of the interaction term (moderator
  value).  Default value is \code{"#3366cc"} (blue-like)}

  \item{upperBoundColor}{the color of the line indicating
  the upper bound of the interaction term (moderator
  value).  Default value is \code{"#cc3300"} (red-like)}

  \item{colorPalette}{If the grouping variable has more
  than two levels, more than two colors are needed for
  plotting the lines. In this case, specify a color palette
  from the \url{http://colorbrewer2.org} here.  All color
  brewer palettes supported by ggplot are accepted here.
  Alternatively, you can provide a vector of colors, i.e.
  \code{c("blue", "red", "gren")}.}

  \item{axisTitle.x}{a default title used for the x-axis.
  Default value is \code{NULL}, which means that each
  plot's x-axis uses the predictor's name as title.}

  \item{axisTitle.y}{a default title used for the y-axis.
  Default value is \code{NULL}, which means that each
  plot's y-axis uses the dependent variable's name as
  title.}

  \item{axisLabelColor}{the color value for the axis labels
  at the tick marks. Default value is \code{"darkgray"}.}

  \item{axisLabelSize}{The size of axis labels. Default is
  1.1, recommended values range between 0.5 and 3.0}

  \item{axisTitleColor}{the color value for the axis titles
  (both x and y). Default value is \code{"black"}.}

  \item{axisTitleSize}{The size of axis titles (both x and
  y). Default is 1.3, recommended values range between 0.5
  and 3.0}

  \item{legendLabels}{Labels for the guide/legend. Default
  is \code{NULL}, so the name of the predictor with
  min/max-effect is used as legend label.}

  \item{legendLabelSize}{The size of legend labels. Default
  is 0.9, recommended values range between 0.5 and 3.0}

  \item{legendLabelColor}{user defined color for legend
  labels. If not specified, black will be used for the
  labels}

  \item{showValueLabels}{if \code{TRUE}, value labels are
  plotted along the lines. Default is \code{FALSE}.}

  \item{valueLabel.digits}{the amount of digits of the
  displayed value labels. Defaults to 2.}

  \item{valueLabelSize}{size of the value labels. Default
  is 4. Recommended Values range from 2 to 8}

  \item{valueLabelColor}{colour of the values inside the
  diagrams. Only applies, when parameter
  \code{showValueLabels} is set to \code{TRUE}. Use any
  valid colour value, e.g. \code{valueLabelColor="grey50"}
  or \code{valueLabelColor=c("#cc3366")}. Default is
  \code{"black"}.}

  \item{valueLabelAlpha}{the alpha level (transparancy) of
  the value labels. Default is 0.8, use any value from 0 to
  1.}

  \item{breakTitleAt}{Wordwrap for diagram's title.
  Determines how many chars of the title are displayed in
  one line and when a line break is inserted. Default is
  \code{50}.}

  \item{breakLegendLabelsAt}{Wordwrap for diagram legend
  labels. Determines how many chars of the legend labels
  are displayed in one line and when a line break is
  inserted. Default is \code{20}.}

  \item{breakAnnotationLabelsAt}{Wordwrap for diagram
  annotation labels. Determines how many chars of the
  legend labels are displayed in one line and when a line
  break is inserted. Default is \code{50}.  Only applies if
  \code{showInterceptLine} is \code{TRUE}.}

  \item{axisLimits.y}{A vector with two values, defining
  the lower and upper limit from the y-axis.  By default,
  this value is \code{NULL}, i.e. axis limits will be
  calculated upon the range of y-values.}

  \item{gridBreaksAt}{Sets the breaks on the y axis, i.e.
  at every n'th position a major grid is being printed.
  Default is \code{NULL}.}

  \item{theme}{Specifies the diagram's background theme.
  Default (parameter \code{NULL}) is a gray background with
  white grids.  \itemize{ \item Use \code{"bw"} for a white
  background with gray grids \item \code{"classic"} for a
  classic theme (black border, no grids) \item
  \code{"minimal"} for a minimalistic theme (no border,gray
  grids) \item \code{"none"} for no borders, grids and
  ticks or \item \code{"themr"} if you are using the
  \code{ggthemr} package (in such cases, you may use the
  \code{ggthemr::swatch} function to retrieve theme-colors
  for the \code{lowerBoundColor} parameter) } See
  \url{http://rpubs.com/sjPlot/custplot} for details and
  examples.}

  \item{showTickMarks}{Whether tick marks of axes should be
  shown or not}

  \item{borderColor}{user defined color of whole diagram
  border (panel border)}

  \item{axisColor}{user defined color of axis border (y-
  and x-axis, in case the axes should have different colors
  than the diagram border).}

  \item{majorGridColor}{specifies the color of the major
  grid lines of the diagram background}

  \item{minorGridColor}{specifies the color of the minor
  grid lines of the diagram background}

  \item{hideGrid.x}{If \code{TRUE}, the x-axis-gridlines
  are hidden. Default if \code{FALSE}.}

  \item{hideGrid.y}{If \code{TRUE}, the y-axis-gridlines
  are hidden. Default if \code{FALSE}.}

  \item{printPlot}{If \code{TRUE} (default), plots the
  results as graph. Use \code{FALSE} if you don't want to
  plot any graphs. In either case, the ggplot-object will
  be returned as value.}
}
\value{
(Insisibily) returns the ggplot-objects with the complete
plot-list (\code{plot.list}) as well as the data frame that
were used for setting up the ggplot-objects
(\code{df.list}).
}
\description{
Plot estimated marginal means of (significant) interaction
terms in linear models (lm). This function may be used to
plot differences in interventions between control and
treatment groups over multiple time points.
}
\note{
Please note that all interaction terms have to be of type
\code{\link{factor}}!  Furthermore, predictors of
interactions that are introduced first into the model are
used as grouping variable, while the latter predictor is
printed along the x-axis (i.e. lm(y~a+b+a:b) means that "a"
is used as grouping variable and "b" is plotted along the
x-axis).
}
\examples{
\dontrun{
# Note that the data sets used in this example may not be perfectly suitable for
# fitting linear models. I just used them because they are part of the R-software.

# prepare data frame
df <- data.frame(mpg=mtcars$mpg,vs=factor(mtcars$vs),am=factor(mtcars$am))
# fit "dummy" model.
fit <- lm(mpg~vs+am+vs:am, data=df)
# show summary to see significant interactions
summary(fit)

# plot marginal means of interaction terms
# note we have to adjust plevel, because no interaction
# is significant
sjp.emm.int(fit, plevel=1)
# plot marginal means of interaction terms, including value labels
sjp.emm.int(fit, plevel=1, showValueLabels=TRUE)


# load sample data set
data(efc)
# create data frame with variables that should be included
# in the model
df <- as.data.frame(cbind(burden=efc$neg_c_7,
                          sex=efc$c161sex,
                          education=efc$c172code))
# convert gender predictor to factor
df$sex <- factor(df$sex)
df$education <- factor(df$education)
# name factor levels and dependent variable
levels(df$sex) <- c("female", "male")
levels(df$education) <- c("low", "mid", "high")
df$burden <- sji.setVariableLabels(df$burden, "care burden")
# fit "dummy" model
fit <- lm(burden ~ .*., data=df, na.action=na.omit)
summary(fit)

# plot marginal means of interactions, no interaction found
sjp.emm.int(fit)
# plot marginal means of interactions, including those with p-value up to 1
sjp.emm.int(fit, plevel=1)
# swap predictors
sjp.emm.int(fit, plevel=1, swapPredictors=TRUE)}
}
\references{
\itemize{ \item \url{http://rpubs.com/sjPlot/sjpemmint}
\item
\url{http://strengejacke.wordpress.com/2014/08/19/visualize-pre-post-comparison-of-intervention-rstats/}
\item
\url{http://www.theanalysisfactor.com/using-adjusted-means-to-interpret-moderators-in-analysis-of-covariance/}
}
}
\seealso{
\code{\link{sjp.lm.int}} \cr \code{\link{sjp.reglin}} \cr
\code{\link{sjp.aov1}} \cr \code{\link{sjp.lm.ma}}
}

