% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotPCA.R
\name{sjp.pca}
\alias{sjp.pca}
\title{Plot PCA results}
\usage{
sjp.pca(data, rotation = c("varimax", "oblimin"), nmbr.fctr = NULL,
  fctr.load.tlrn = 0.1, plot.eigen = FALSE, digits = 2, title = NULL,
  axis.labels = NULL, type = c("bar", "circle", "tile"), geom.size = 0.6,
  geom.colors = "RdBu", wrap.title = 50, wrap.labels = 30,
  show.values = TRUE, show.cronb = TRUE, prnt.plot = TRUE)
}
\arguments{
\item{data}{A data frame that should be used to compute a PCA, or a \code{\link{prcomp}} object.}

\item{rotation}{Rotation of the factor loadings. May be \code{"varimax"} for orthogonal rotation
or \code{"oblimin"} for oblique transformation.}

\item{nmbr.fctr}{Number of factors used for calculating the rotation. By
default, this value is \code{NULL} and the amount of factors is
calculated according to the Kaiser-criteria.}

\item{fctr.load.tlrn}{Specifies the minimum difference a variable needs to have between
factor loadings (components) in order to indicate a clear loading on just one factor and not
diffusing over all factors. For instance, a variable with 0.8, 0.82 and 0.84 factor loading
on 3 possible factors can not be clearly assigned to just one factor and thus would be removed
from the principal component analysis. By default, the minimum difference of loading values
between the highest and 2nd highest factor should be 0.1}

\item{plot.eigen}{If \code{TRUE}, a plot showing the Eigenvalues according to the
Kaiser criteria is plotted to determine the number of factors.}

\item{digits}{Numeric, amount of digits after decimal point when rounding estimates and values.}

\item{title}{character vector, used as plot title. Depending on plot type and function,
will be set automatically. If \code{title = ""}, no title is printed.
For effect-plots, may also be a character vector of length > 1,
to define titles for each sub-plot or facet.}

\item{axis.labels}{character vector with labels used as axis labels. Optional
argument, since in most cases, axis labels are set automatically.}

\item{type}{Plot type resp. geom type. May be one of following: \code{"circle"} or \code{"tile"}
circular or tiled geoms, or \code{"bar"} for a bar plot. You may use initial letter only
for this argument.}

\item{geom.size}{size resp. width of the geoms (bar width, line thickness or point size,
depending on plot type and function). Note that bar and bin widths mostly
need smaller values than dot sizes.}

\item{geom.colors}{user defined color for geoms. See 'Details' in \code{\link{sjp.grpfrq}}.}

\item{wrap.title}{numeric, determines how many chars of the plot title are displayed in
one line and when a line break is inserted.}

\item{wrap.labels}{numeric, determines how many chars of the value, variable or axis
labels are displayed in one line and when a line break is inserted.}

\item{show.values}{logical, whether values should be plotted or not.}

\item{show.cronb}{Logical, if \code{TRUE} (default), the cronbach's alpha value for each factor scale will be calculated,
i.e. all variables with the highest loading for a factor are taken for the
reliability test. The result is an alpha value for each factor dimension.
Only applies when \code{data} is a data frame.}

\item{prnt.plot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Invisibly) returns a \code{\link{structure}} with
         \itemize{
           \item the rotated factor loading matrix (\code{varim})
           \item the column indices of removed variables (for more details see next list item) (\code{removed.colindex})
           \item an updated data frame containing all factors that have a clear loading on a specific scale in case \code{data} was a data frame (See argument \code{fctr.load.tlrn} for more details) (\code{removed.df})
           \item the \code{factor.index}, i.e. the column index of each variable with the highest factor loading for each factor,
           \item the ggplot-object (\code{plot}),
           \item the data frame that was used for setting up the ggplot-object (\code{df}).
           }
}
\description{
Performs a principle component analysis on a data frame or matrix (with
               varimax or oblimin rotation) and plots the factor solution as ellipses or tiles. \cr \cr
               In case a data frame is used as argument, the cronbach's alpha value for
               each factor scale will be calculated, i.e. all variables with the highest
               loading for a factor are taken for the reliability test. The result is
               an alpha value for each factor dimension.
}
\examples{
library(sjmisc)
data(efc)
# recveive first item of COPE-index scale
start <- which(colnames(efc) == "c82cop1")
# recveive last item of COPE-index scale
end <- which(colnames(efc) == "c90cop9")

# manually compute PCA
pca <- prcomp(
  na.omit(efc[, start:end]),
  retx = TRUE,
  center = TRUE,
  scale. = TRUE
)
# plot results from PCA as circles, including Eigenvalue-diagnostic.
# note that this plot does not compute the Cronbach's Alpha
sjp.pca(pca, plot.eigen = TRUE, type = "circle", geom.size = 10)

# use data frame as argument, let sjp.pca() compute PCA
sjp.pca(efc[, start:end])
sjp.pca(efc[, start:end], type = "tile")


}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/sjp.pca/}{sjPlot manual: sjp.pca}
           \item \code{\link{sjt.pca}}
           }
}
