% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_note.R
\name{get_note}
\alias{get_note}
\title{Retrieve notes (annotations) from labelled variables}
\usage{
get_note(x)
}
\arguments{
\item{x}{Variable (vector) with note-attribute.}
}
\value{
The the value of the \code{note}-attribute of \code{x}.
}
\description{
This function retrieves the value of the \code{note}-attribute
               of vectors.
}
\examples{
library(haven)
# create labelled factor
x <- labelled(c("M", "M", "F", "X", "N/A"),
              c(Male = "M", Female = "F",
                Refused = "X", "Not applicable" = "N/A"))

set_label(x) <- "A labelled vector with note"
set_note(x) <- "Test annotation."
get_note(x)
x

# Annotate simple vector
x <- c(1, 2, 3)
set_note(x) <- "Another note"
x
get_note(x)

}

