% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_labels.R, R/fill_labels.R, R/zap_labels.R
\name{drop_labels}
\alias{drop_labels}
\alias{fill_labels}
\alias{zap_labels}
\alias{zap_unlabelled}
\title{Drop, add or convert (non-)labelled values}
\usage{
drop_labels(x, ..., drop.na = TRUE)

fill_labels(x, ...)

zap_labels(x, ...)

zap_unlabelled(x, ...)
}
\arguments{
\item{x}{(partially) \code{\link[haven]{labelled}} vector or a data frame
with such vectors.}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or dplyr's \code{\link[dplyr]{select_helpers}}.
The latter must be stated as formula (i.e. beginning with \code{~}).
See 'Examples' or \href{../doc/design_philosophy.html}{package-vignette}.}

\item{drop.na}{Logical, whether existing value labels of tagged NA values
(see \code{\link[haven]{tagged_na}}) should be removed (\code{drop.na = TRUE},
the default) or preserved (\code{drop.na = FALSE}).
See \code{\link{get_na}} for more details on tagged NA values.}
}
\value{
\itemize{
          \item For \code{zap_labels()}, \code{x}, where all labelled values are converted to \code{NA}.
          \item For \code{zap_unlabelled()}, \code{x}, where all non-labelled values are converted to \code{NA}.
          \item For \code{drop_labels()}, \code{x}, where value labels for non-existing values are removed.
          \item For \code{fill_labels()}, \code{x}, where labels for non-labelled values are added.
        }
        If \code{x} is a data frame, the complete data frame \code{x} will be
        returned, with variables specified in \code{...} being converted;
        if \code{...} is not specified, applies to all variables in the
        data frame.
}
\description{
For (partially) labelled vectors, \code{zap_labels()} will replace
               all values that have a value label attribute by \code{NA};
               \code{zap_unlabelled()}, as counterpart, will replace all values
               that \emph{don't} have a value label attribute by \code{NA}.
               \cr \cr
               \code{drop_labels()} drops all value labels for unused values that have
               no cases (counts) in a vector. \code{fill_labels()} is the
               counterpart to \code{drop_labels()} and adds value labels to
               a partially labelled vector, i.e. if not all values are
               labelled, non-labelled values get labels.
}
\examples{
# ------------------------
# zap_labels()
# ------------------------
data(efc)
str(efc$e42dep)

x <- set_labels(
  efc$e42dep,
  labels = c("independent" = 1, "severe dependency" = 4)
)
table(x)
get_values(x)
str(x)

# zap all labelled values
table(zap_labels(x))
get_values(zap_labels(x))
str(zap_labels(x))

# zap all unlabelled values
table(zap_unlabelled(x))
get_values(zap_unlabelled(x))
str(zap_unlabelled(x))

# in a pipe-workflow
library(dplyr)
efc \%>\%
  select(c172code, e42dep) \%>\%
  set_labels(
    e42dep,
    labels = c("independent" = 1, "severe dependency" = 4)
  ) \%>\%
  zap_labels()

# ------------------------
# drop_labels()
# ------------------------
rp <- rec_pattern(1, 100)
rp

# sample data
data(efc)
# recode carers age into groups of width 5
x <- rec(efc$c160age, rec = rp$pattern)
# add value labels to new vector
x <- set_labels(x, labels = rp$labels)

# watch result. due to recode-pattern, we have age groups with
# no observations (zero-counts)
frq(x)
# now, let's drop zero's
frq(drop_labels(x))

# drop labels, also drop NA value labels, then also zap tagged NA
library(haven)
x <- labelled(c(1:3, tagged_na("z"), 4:1),
              c("Agreement" = 1, "Disagreement" = 4, "Unused" = 5,
                "Not home" = tagged_na("z")))
x
drop_labels(x, drop.na = FALSE)
drop_labels(x)
zap_na_tags(drop_labels(x))

# ------------------------
# fill_labels()
# ------------------------
# create labelled integer, with tagged missings
library(haven)
x <- labelled(c(1:3, tagged_na("a", "c", "z"), 4:1),
              c("Agreement" = 1, "Disagreement" = 4, "First" = tagged_na("c"),
                "Refused" = tagged_na("a"), "Not home" = tagged_na("z")))
# get current values and labels
x
get_labels(x)

fill_labels(x)
get_labels(fill_labels(x))
# same as
get_labels(x, include.non.labelled = TRUE)

}
