% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop.R
\name{prop}
\alias{prop}
\alias{props}
\title{Proportions of values in a vector}
\usage{
prop(data, ..., weight.by = NULL, na.rm = TRUE, digits = 4)

props(data, ..., na.rm = TRUE, digits = 4)
}
\arguments{
\item{data}{A data frame. May also be a grouped data frame (see 'Examples').}

\item{...}{One or more value pairs of comparisons (logical predicates). Put
variable names the left-hand-side and values to match on the
right hand side. Expressions may be quoted or unquoted. See
'Examples'.}

\item{weight.by}{Vector of weights that will be applied to weight all observations.
Must be a vector of same length as the input vector. Default is
\code{NULL}, so no weights are used.}

\item{na.rm}{Logical, whether to remove NA values from the vector when the
proportion is calculated. \code{na.rm = FALSE} gives you the raw
percentage of a value in a vector, \code{na.rm = TRUE} the valid
percentage.}

\item{digits}{Amount of digits for returned values.}
}
\value{
For one condition, a numeric value with the proportion of the values
        inside a vector. For more than one condition, a tibble with one column
        of conditions and one column with proportions. For grouped data frames,
        returns a tibble with one column per group with grouping categories,
        followed by one column with proportions per condition.
}
\description{
\code{prop()} calculates the proportion of a value or category
               in a variable. \code{props()} does the same, but allows for
               multiple logical conditions in one statement.
}
\details{
\code{prop()} only allows one logical statement per comparison,
         while \code{props()} allows multiple logical statements per comparison.
         However, \code{prop()} supports weighting of variables before calculating
         proportions, and comparisons may also be quoted. Hence, \code{prop()}
         also processes comparisons, which are passed as character vector
         (see 'Examples').
}
\examples{
data(efc)

# proportion of value 1 in e42dep
prop(efc, e42dep == 1)

# expression may also be completely quoted
prop(efc, "e42dep == 1")

# use "props()" for multiple logical statements
props(efc, e17age > 70 & e17age < 80)

# proportion of value 1 in e42dep, and all values greater
# than 2 in e42dep, including missing values. will return a tibble
prop(efc, e42dep == 1, e42dep > 2, na.rm = FALSE)

# for factors or character vectors, use quoted or unquoted values
library(sjmisc)
# convert numeric to factor, using labels as factor levels
efc$e16sex <- to_label(efc$e16sex)
efc$n4pstu <- to_label(efc$n4pstu)

# get proportion of female older persons
prop(efc, e16sex == female)

# get proportion of male older persons
prop(efc, e16sex == "male")

# "props()" needs quotes around non-numeric factor levels
props(efc,
  e17age > 70 & e17age < 80,
  n4pstu == 'Care Level 1' | n4pstu == 'Care Level 3'
)

# also works with pipe-chains
library(dplyr)
efc \%>\% prop(e17age > 70)
efc \%>\% prop(e17age > 70, e16sex == 1)

# and with group_by
efc \%>\%
  group_by(e16sex) \%>\%
  prop(e42dep > 2)

efc \%>\%
  select(e42dep, c161sex, c172code, e16sex) \%>\%
  group_by(c161sex, c172code) \%>\%
  prop(e42dep > 2, e16sex == 1)

# same for "props()"
efc \%>\%
  select(e42dep, c161sex, c172code, c12hour, n4pstu) \%>\%
  group_by(c161sex, c172code) \%>\%
  props(
    e42dep > 2,
    c12hour > 20 & c12hour < 40,
    n4pstu == 'Care Level 1' | n4pstu == 'Care Level 3'
  )

}
