% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phi.R
\name{phi}
\alias{phi}
\alias{cramer}
\title{Measures of associations for contingency tables}
\usage{
phi(tab)

cramer(tab)
}
\arguments{
\item{tab}{A \code{\link{table}} or \code{\link{ftable}}. Tables of class
\code{\link{xtabs}} and other will be coerced to \code{\link{ftable}}
objects.}
}
\value{
\itemize{
          \item For \code{phi()}, the table's Phi value.
          \item For \code{cramer()}, the table's Cramer's V.
        }
}
\description{
Compute measures of associtations for a contingency table,
             like \emph{Phi coefficient} or \emph{Cramer's V}.
}
\examples{
# Phi coefficient for 2x2 tables
tab <- table(sample(1:2, 30, TRUE), sample(1:2, 30, TRUE))
phi(tab)

# Cramer's V for nominal variables with more than 2 categories
tab <- table(sample(1:2, 30, TRUE), sample(1:3, 30, TRUE))
cramer(tab)

}
