% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goldfeld_quandt.R
\name{goldfeld_quandt}
\alias{goldfeld_quandt}
\title{Goldfeld-Quandt Tests for Heteroskedasticity in a Linear Regression Model}
\usage{
goldfeld_quandt(
  mainlm,
  method = "parametric",
  deflator = NULL,
  prop_central = 1/3,
  alternative = c("greater", "less", "two.sided"),
  pvals = NULL
)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} "lm", or a list
of two components: a response vector and a design matrix (in that order).
If the latter, the design matrix must begin with a column of 1s if an
intercept is to be included in the linear model. Passing an object of
class "lm" is recommended in applications; passing a list containing
the data is recommended where optimising computational performance is
important.}

\item{method}{A character indicating which of the two tests derived in
\insertCite{Goldfeld65;textual}{skedastic} should be implemented.
Possible values are "parametric" and "nonparametric". Default is
"parametric". It is acceptable to specify only the first letter.}

\item{deflator}{Either a character specifying a column name from the
design matrix of \code{mainlm} or an integer giving the index of a
column of the design matrix. This variable is suspected to be
related to the error variance under the alternative hypothesis.
\code{deflator} may not correspond to a column of 1's (intercept).
Default \code{NULL} means the data will be left in its current order
(e.g. in case the existing index is believed to be associated with
error variance).}

\item{prop_central}{A double specifying the proportion of central
observations to exclude from the F test (when \code{method} is
\code{"parametric"} only). \code{\link[base]{round}} is
used to ensure the number of central observations is an integer. The
value must be small enough to allow the two auxiliary regressions to
be fit; otherwise an error is thrown. Defaults to \eqn{1/3}.}

\item{alternative}{A character specifying the form of alternative
hypothesis ((when \code{method} is \code{"parametric"} only;
nonparametric test is strictly upper-tailed). If it is suspected that
the error variance is positively associated with the deflator variable,
"greater". If it is suspected that error variance is negatively
associated with deflator variable, "less". If no prior information is
available, "two.sided". Defaults to "greater".}

\item{pvals}{A vector of \eqn{p}-values, i.e. upper cumulative probabilities
corresponding to to values of the test statistic from 0 to \eqn{n-1} (used
only when \code{method} is \code{"nonparametric"}). If
\code{NULL} (the default), p-values are calculated within the function.
To improve performance where the test is being used many times (e.g. in
a Monte Carlo simulation), a vector of \eqn{p}-values for a particular
\eqn{n} can be computed beforehand using \code{\link{ppeak}} and passed
to the function, so that the \eqn{p}-values are not computed each time the
function executes (see Examples). Computation of \code{\link{ppeak}} is
extremely slow for \eqn{n > 170}.}
}
\value{
An object of \code{\link[base]{class}} "htest". If object is not
   assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the two methods (parametric and nonparametric) of
   \insertCite{Goldfeld65;textual}{skedastic} for testing for heteroskedasticity
   in a linear regression model.
}
\details{
The parametric test entails putting the data rows in increasing order of
   some specified deflator (one of the explanatory variables). A specified
   proportion of the most central observations (under this ordering) is
   removed, leaving a subset of lower observations and a subset of upper
   observations. Separate OLS regressions are fit to these two subsets of
   observations (using all variables from the original model). The test
   statistic is the ratio of the sum of squared residuals from the
   'upper' model to the sum of squared residuals from the 'lower' model.
   Under the null hypothesis, the test statistic is exactly F-distributed
   with numerator and denominator degrees of freedom equal to
   \eqn{(n-k)/2 - p} where \eqn{n} is the number of observations in the
   original regression model, \eqn{k} is the number of central observations
   removed, and \eqn{p} is the number of columns in the design matrix (number of
   parameters to be estimated, including intercept).

The nonparametric test entails putting the residuals of the linear model in
   increasing order of some specified deflator (one of the explanatory
   variables). The test statistic is the number of peaks, with the \eqn{j}th
   absolute residual \eqn{|e_j|} defined as a peak if \eqn{|e_j|\ge|e_i|}
   for all \eqn{i<j}. The first observation does not constitute a peak. If
   the number of peaks is large relative to the distribution of peaks under
   the null hypothesis, this constitutes evidence for heteroskedasticity.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
goldfeld_quandt(mtcars_lm, deflator = "qsec", prop_central = 0.25)
goldfeld_quandt(mtcars_lm, deflator = "qsec", method = "nonparametric")

}
\references{
{\insertAllCited{}}
}
\seealso{
\code{\link[lmtest:gqtest]{lmtest::gqtest}}, which performs the
   parametric version of the Goldfeld-Quandt Test. The `point` argument in
   that function allows the splitting point of data set into subsets to be
   other than the middle observation and thus allows the subsets to be of
   different sizes.
}
