% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_to_gitignore.R
\name{add_to_gitignore}
\alias{add_to_gitignore}
\title{Add entries to gitignore}
\usage{
add_to_gitignore(add.to.gitignore = FALSE, cutoff = NULL, extension = NULL, path = ".")
}
\arguments{
\item{add.to.gitignore}{Logical to control if files are added to 'gitignore' or just printed on the console.}

\item{cutoff}{Numeric. Defines the file size (in MB) cutoff used to find files (i.e. only files above the threshold would returned). 99 (MB) is recommended when hosting projects at github as the current file size limit is 100 MB.}

\item{extension}{Character string to define the file extension of the files to be searched for.}

\item{path}{Path to the project directory. Default is current directory.}
}
\value{
Prints the name of the files matching the searching parameters. If \code{add.to.ignore = TRUE} the files matching the search parameters ('cutoff' and/or 'extension') would be added 'gitignore' (a file used by git to exclude files form version control, including adding them to github).
}
\description{
\code{add_to_gitignore} adds entries to gitignore based on file extension or file size
}
\details{
The function can be used to avoid conflicts when working with large files or just avoid adding non-binary files to remote repositories. It mostly aims to simplify spotting/excluding large files. Note that file names can be manually added to the '.gitignore' file using a text editor.
}
\examples{
{
data(compendiums)

make_compendium(name = "my_compendium", path = tempdir(),
 format = "basic", force = TRUE)

# save a file
write.csv(iris, file.path(tempdir(), "my_compendium", "iris.csv"))

# add the file to gitignore
add_to_gitignore(add.to.gitignore = TRUE,
path = file.path(tempdir(), "my_compendium"), extension = "csv")
}

}
\references{
{
Araya-Salas, M., Willink, B., Arriaga, A. (2020), sketchy: research compendiums for data analysis in R. R package version 1.0.2.
}
}
\seealso{
\code{\link{compendiums}}, \code{\link{make_compendium}}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
