% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime_wfs_heatmap.R
\name{modeltime_wfs_heatmap}
\alias{modeltime_wfs_heatmap}
\title{Modeltime workflowsets heatmap plot}
\usage{
modeltime_wfs_heatmap(
  .wfs_results,
  metric = "rsq",
  low_color = "#c7e9b4",
  high_color = "#253494"
)
}
\arguments{
\item{.wfs_results}{a tibble generated with the \code{modeltime_wfs_fit()} function.}

\item{metric}{a metric the metric used for the heatmap values: 'mae', 'mape','mase','smape','rmse','rsq'.}

\item{low_color}{color for the worst metric (highest error or lowest rsq).}

\item{high_color}{color for the better metric (lowest error or highest rsq).}
}
\value{
a ggplot heatmap.
}
\description{
generate a heatmap for each recipe and model on a object generated with the \code{modeltime_wfs_fit()} function.
}
\details{
assumes that the workflows included in the 'workflow_set' object are named M_{name_of_model},
since the .model_id is {recipe_name}\emph{M}{name_of_model} and the '\emph{M}' is used to separate the
recipe from the model name.
}
\examples{
library(modeltime)
library(dplyr)
library(parsnip)
library(earth)

data <- sknifedatar::data_avellaneda \%>\% mutate(date=as.Date(date)) \%>\% filter(date<'2011-01-01')

recipe_date <- recipes::recipe(value ~ ., data = data) \%>\% 
  recipes::step_date(date, features = c('dow','doy','week','month','year')) 

mars_backward <- mars(prune_method ='backward', mode = 'regression') \%>\% set_engine('earth')

mars_forward <- mars(prune_method = 'forward', mode = 'regression') \%>\% set_engine('earth')

wfsets <- workflowsets::workflow_set(
  preproc = list(
    date = recipe_date),
  models  = list(M_mars_backward = mars_backward, 
                 M_mars_forward = mars_forward),
  cross   = TRUE)

wffits <- sknifedatar::modeltime_wfs_fit(.wfsets = wfsets, 
                                         .split_prop = 0.6, 
                                         .serie=data)

sknifedatar::modeltime_wfs_heatmap(wffits, 'rsq')

}
