% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime_wfs_fit.R
\name{modeltime_wfs_fit}
\alias{modeltime_wfs_fit}
\title{Modeltime workflowsets fit}
\usage{
modeltime_wfs_fit(.wfsets, .split_prop, .serie)
}
\arguments{
\item{.wfsets}{workflow_set object, generated with the \code{workflow_set()} function from the 'workflowsets' package.}

\item{.split_prop}{time series split proportion.}

\item{.serie}{time series dataframe.}
}
\value{
tbl_df containing the model id (based on workflow_set), model description and metrics on the time
series testing dataframe. Also, a .fit_model column is included, which contains each fitted model.
}
\description{
allows working with workflow sets and modeltime. Combination of recipes and models are trained and
evaluation metrics are returned.
}
\details{
Given a workflow_set containing multiple time series recipes and models, adjusts all the possible combinations
on a time series. It uses a split proportion in order to train on a time series partition and evaluate metrics
on the testing partition.
}
\examples{
library(dplyr)
library(earth)

data <- sknifedatar::data_avellaneda \%>\% mutate(date=as.Date(date)) \%>\% filter(date<'2012-06-01')

recipe_date <- recipes::recipe(value ~ ., data = data) \%>\% 
  recipes::step_date(date, features = c('dow','doy','week','month','year')) 

mars <- parsnip::mars(mode = 'regression') \%>\% parsnip::set_engine('earth')

wfsets <- workflowsets::workflow_set(
  preproc = list(
    R_date = recipe_date),
  models  = list(M_mars = mars),
  cross   = TRUE)

sknifedatar::modeltime_wfs_fit(.wfsets = wfsets, 
                               .split_prop = 0.8, 
                               .serie = data)
                            
}
\seealso{
\href{https://rafzamb.github.io/sknifedatar/}{sknifedatar website}
}
