% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_optimality.R
\name{get_optimality}
\alias{get_optimality}
\title{Get optimality values}
\usage{
get_optimality(output, optimality = NULL, calc_g = FALSE)
}
\arguments{
\item{output}{The output of either \code{\link[=gen_design]{gen_design()}}, \code{\link[=eval_design]{eval_design()}}, or \code{\link[=eval_design_mc]{eval_design_mc()}}.}

\item{optimality}{Default \code{NULL}. Return just the specific optimality requested.}

\item{calc_g}{Default \code{FALSE}. Whether to calculate the g-efficiency.}
}
\value{
A dataframe of optimality conditions. \code{D}, \code{A}, and \code{G} are efficiencies (value is out of 100).
\code{T} is the trace of the information matrix, \code{E} is the minimum eigenvalue of the information matrix,
\code{I} is the average prediction variance, and \code{Alias} is the trace of the alias matrix.
}
\description{
Returns a list of optimality values (or one value in particular).

Note: The choice of contrast will effect the \code{G} efficiency value, and \code{\link[=gen_design]{gen_design()}}
and \code{\link[=eval_design]{eval_design()}} by default set different contrasts (\code{\link[=contr.simplex]{contr.simplex()}} vs \code{contr.sum}).
}
\examples{
# We can extract the optimality of a design from either the output of `gen_design()`
# or the output of `eval_design()`

factorialcoffee = expand.grid(cost = c(1, 2),
                             type = as.factor(c("Kona", "Colombian", "Ethiopian", "Sumatra")),
                             size = as.factor(c("Short", "Grande", "Venti")))

designcoffee = gen_design(factorialcoffee, ~cost + size + type, trials = 29,
                         optimality = "D", repeats = 100)

#Extract a list of all attributes
get_optimality(designcoffee)

#Get just one attribute
get_optimality(designcoffee,"D")

# Extract from `eval_design()` output
power_output = eval_design(designcoffee, model = ~cost + size + type,
                          alpha = 0.05, detailedoutput = TRUE)

get_optimality(power_output)
}
