% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotHor}
\alias{plotHor}
\title{Plot horizon data}
\usage{
plotHor(hor, show.az = F, max.alt, az0 = 0, zoom = F, obj, measure, ...)
}
\arguments{
\item{hor}{Object of \emph{skyscapeR.horizon} format.}

\item{show.az}{Boolean that controls whether to display azimuth values on horizontal axis.
Defaults to \emph{FALSE}.}

\item{max.alt}{Maximum altitude to display. Defaults to 45 degrees.}

\item{az0}{Leftmost azimuth of plot. Defaults to 0 degrees, i.e. North at the left.}

\item{zoom}{Boolean that controls whether to provide a zoomed-in view of 100 degrees in
azimuth and 5 degrees of altitude above the horizon line. Defaults to \emph{FALSE}.}

\item{obj}{(Optional) A \emph{skyscapeR.object} object created with \code{\link{sky.objects}}
for displaying the paths of celestial objects.}

\item{measure}{(Optional) A data.frame object with columns \emph{True.Azimuth} and
\emph{Altitude} such as the ones produced by \code{\link{reduct.compass}} or
\code{\link{reduct.theodolite}}. If no column named \emph{Altitude} is found then it will
plot all azimuths are zero degrees altitude.}

\item{...}{Any other parameters to be passed unto \code{\link{plot.default}}.}
}
\description{
This function creates a plot of horizon data.
}
\examples{
# Plot a horizon retrieved from HeyWhatsThat:
hor <- download.HWT('HIFVTBGK')
plotHor(hor)

# Add the paths of the solstices and equinoxes sun in the year 1999 BC:
tt <- sky.objects('sun', -2000, 'blue')
plotHor(hor, objects=tt)
}
\seealso{
\code{\link{download.HWT}}, \code{\link{sky.objects}}
}
