% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stars.R
\name{star.phases}
\alias{star.phases}
\title{Calculate the seasons and phases of a star}
\usage{
star.phases(star, year, loc, alt.hor = 0, alt.rs = 10, res = 24/3600,
  ncores)
}
\arguments{
\item{star}{Either the star name or a \emph{skyscapeR.star} object.}

\item{year}{The year of interest.}

\item{loc}{Location, either a \emph{skyscapeR.object} or a vector
containing the latitude and longitude of location, in this order.}

\item{alt.hor}{(Optional) The altitude of the horizon to consider.
Defaults to zero degrees.}

\item{alt.rs}{(Optional) The maximum altitude of a star's first or last
visibility for it to still be considered to be as rising or setting.
Defaults to ten degrees.}

\item{res}{(Optional) Resolution of calculation. The smaller this
figure the slower the computation. Defaults to 24/3600 = 1 sec.}

\item{ncores}{(Optional) Number of processing cores to use for parallelisation.
Defaults to the number of available cores minus 1.}
}
\description{
This function calculates the seasons (Rising, Setting, etc.)
and phases (Arising and Lying Hidden, Curtailed Passage) of a
star for a given location and epoch. This functions uses the
\emph{arcus visionis} approximation of Purrington (1988). For
the nomenclature used, and description of star phases, see Brady (2015).
}
\examples{
\dontrun{
ss1 <- star.phases('Aldebaran',-4000, c(35,-8))

# One can then look at the star's phase:
ss1$phase

# Date range of seasons:
ss1$seasons

# Date range of events/phases:
ss1$events

# And plot them:
plotPhases(ss1)

# You can play with the parameters and see how predictions change:
ss1 <- star.phases('Aldebaran',-4000, c(35,-8), alt.hor=2, alt.rs=5)
plotPhases(ss1)
}
}
\references{
Purrington, Robert D. (1988) Heliacal Rising and Setting:
Quantitative Aspects, \emph{Journal for the History of Astronomy
(Archaeoastronomy Supplement 12)} 19, S72-S84. Available online at
[SAO/NASA ADS Astronomy Abstract Service](http://adsabs.harvard.edu/abs/1988JHAS...19...72P)

Brady, Bernadette (2015) Star Phases: the Naked-eye Astronomy of the Old Kingdom
Pyramid Texts. In F Silva and N Campion (eds) \emph{Skyscapes: The Role and Importance of
the Sky in Archaeology}. Oxford: Oxbow Books, pp. 76-86.
}
\seealso{
\code{\link{plotPhases}}
}
