% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.skyscapeR.horizon}
\alias{plot.skyscapeR.horizon}
\title{Plot horizon data}
\usage{
\method{plot}{skyscapeR.horizon}(
  x,
  show.az = F,
  xlim,
  ylim,
  obj,
  refraction = F,
  col.ground = "#fdae61",
  ...
)
}
\arguments{
\item{x}{Object of \emph{skyscapeR.horizon} format.}

\item{show.az}{(Optional) Boolean that controls whether to display azimuth values or cardinal
directions. Defaults to FALSE.}

\item{xlim}{(Optional) Azimuth rage for plotting.}

\item{ylim}{(Optional) Altitude rage for plotting.}

\item{obj}{(Optional) A \emph{skyscapeR.object} object created with \code{\link{sky.objects}}
for displaying the paths of celestial objects.}

\item{refraction}{(Optional) Boolean switch controlling whether to take refraction into account
when displaying the paths of celestial objects.}

\item{col.ground}{(Optional) Color of the ground. Defaults to \emph{#fdae61}.}

\item{...}{Additional arguments to be passed to \emph{plot}.}
}
\description{
This function creates a plot of horizon data.
}
\examples{
# Plot a horizon retrieved from HeyWhatsThat:
hor <- downloadHWT('HIFVTBGK')
plot(hor)

# Add the paths of the solstices and equinoxes sun in the year 1999 BC:
tt <- sky.objects('solar extremes', epoch=-2000, col='blue')
plot(hor, obj=tt)
}
\seealso{
\code{\link{downloadHWT}}, \code{\link{sky.objects}}
}
