% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{randomTest}
\alias{randomTest}
\title{Significance test against the null hypothesis of random orientation}
\usage{
randomTest(
  pdf,
  nsims = 1000,
  conf = 0.95,
  tails = 2,
  normalise = F,
  ncores = parallel::detectCores() - 1,
  save.sim = F,
  verbose = T
)
}
\arguments{
\item{pdf}{A \emph{skyscapeR.pdf} object created with either \code{\link{az.pdf}} or \code{\link{coordtrans}}}

\item{nsims}{(Optional) Boolean switch controlling whether to normalize the SPD. Default is FALSE}

\item{conf}{(Optional) Array of values (min and max) for SPD if different from range of \emph{pdf}}

\item{tails}{(Optional) Whether to calculate 1-tailed p-value (greater than) or 2-tailed p-value (smaller than or greater than).
Default is 2.}

\item{normalise}{(Optional) Boolean to control whether to normalize SPDs. Default is FALSE}

\item{ncores}{(Optional) Number of CPU cores to use. Default is the number of available cores minus 1.}

\item{save.sim}{(Optional) Boolean to control whether to save the output of each random simulation.
For testing/advanced use only. Default is FALSE}

\item{verbose}{(Optional) Boolean to control whether or not to display text. Default is TRUE.}
}
\description{
Significance test against the null hypothesis of random orientation
}
\examples{
\dontrun{
# significance test for azimuth
Az <- az.pdf(az=c(87,93,90,110), unc=3)
st1 <- randomTest(Az, nsims=1000)
plot(st1)

# significance test for declination
hor <- createHor(az=c(0,360), alt=c(0,0), loc=c(35,-8,25)) # flat horizon with 0 degrees of altitude
Dec <- coordtrans(Az, hor)
st2 <- randomTest(Dec, nsims=1000)
plot(st2)
}
}
\references{
Silva, F (2020) A probabilistic framework and significance test for the analysis of structural orientations
 in skyscape archaeology \emph{Journal of Archaeological Science} 118, 105138. <doi:10.1016/j.jas.2020.105138>
}
