% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/planetarium.R
\name{sky.sketch}
\alias{sky.sketch}
\title{Create a simplistic sketch of the sky at a given moment in time}
\usage{
sky.sketch(
  time,
  timezone,
  calendar,
  xrange = c(30, 150),
  yrange = c(-45, 45),
  sun = T,
  moon = T,
  planets = F,
  exagerate = T,
  max.mag = 6,
  loc,
  atm,
  temp
)
}
\arguments{
\item{time}{Either a string containing the date and time in the format "YYYY-MM-DD HH:MM:SS"
(see \code{\link{timestring}}), or a numeric containing the julian date (see \code{\link{time2jd}}).}

\item{timezone}{(Optional) Timezone of input either as a known acronym (e.g. "GMT", "CET") or
a string with continent followed by country capital (e.g. "Europe/London"). See
\link{timezones} for details. Only needed if \emph{time} is a string. If not given the value set
by \code{\link{skyscapeR.vars}} will be used instead.}

\item{calendar}{(Optional) Calendar used in parameter \emph{time}. G for gregorian and J for julian.
Only needed if \emph{time} is a string. If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{xrange}{Range of azimuths to display, preferably no larger than 120 degrees.}

\item{yrange}{Range of altitudes to display, preferably no larger than 120 degrees.}

\item{sun}{(Optional) Boolean on whether the sun should be displayed. Defaults to \emph{TRUE}.}

\item{moon}{(Optional) Boolean on whether the moon should be displayed. Defaults to \emph{TRUE}.}

\item{planets}{(Optional) Boolean on whether the visible planets should be displayed. Defaults to \emph{FALSE}.}

\item{exagerate}{(Optional) Boolean on whether the size of the sun, moon and planets should be exaggerated,
which can be useful when attempting wider viewing angles. Defaults to \emph{TRUE}.}

\item{max.mag}{(Optional) Maximum magnitude of stars to consider. Default is 6.}

\item{loc}{Location, either a \emph{skyscapeR.object} or a vector
containing the latitude and longitude of location, in this order.}

\item{atm}{(Optional) Atmospheric pressure for refraction calculation.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{temp}{(Optional) Atmospheric temperature for refraction calculation.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}
}
\description{
Create a simplistic sketch of the sky at a given moment in time
}
\examples{
sky.sketch(time='2019/01/10 18:51', loc=c(35,-8,100))
}
