#' Gather Draft Information
#'
#' Given a draft ID, gather draft information for selection.
#'
#' @return Returns a list containing information about the draft.
#' @author Nick Bultman, \email{njbultman74@@gmail.com}, December 2021
#' @keywords draft
#' @importFrom httr GET content
#' @importFrom jsonlite fromJSON
#' @export
#' @examples
#' \dontrun{get_draft(688281872463106048)}
#'
#' @param draft_id Draft ID generated by Sleeper (integer)
#'
get_draft <- function(draft_id) {
  # Execute query to API given draft ID specified
  x <- jsonlite::fromJSON(httr::content(httr::GET(paste0("https://api.sleeper.app/v1/draft/", draft_id)), as = "text"))
  # Check if returned object is NULL
  if(is.null(x)) {
    # If NULL, inform user and return nothing
    message("No data returned - are you sure the league ID was entered correctly?")
  } else {
    # If not NULL, return the object (list)
    return(x)
  }
}
