% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_regular_season_rankings.R
\name{plot_regular_season_rankings}
\alias{plot_regular_season_rankings}
\title{Plot Regular Season League Rankings}
\usage{
plot_regular_season_rankings(
  league_id,
  title = "<b>Regular Season Rankings</b>",
  tick_color = "black",
  rank_high_fill = "lightgreen",
  rank_low_fill = "#f68383"
)
}
\arguments{
\item{league_id}{League ID assigned by Sleeper (numeric).}

\item{title}{Title for plot, which can include HTML formatting (string).}

\item{tick_color}{Font color, name or hex, for display names (string).}

\item{rank_high_fill}{Bar color, name or hex, for highest rank (string).}

\item{rank_low_fill}{Bar color, name or hex, for lowest rank (string).}
}
\value{
Returns a plot containing the regular season league rankings.
}
\description{
Given the league ID, plot the regular season league rankings. This is
done by assigning positive points to wins and negative points to losses
and then also adding in fantasy points for. The calculation can be seen
in the get_main_data function.
}
\examples{
\dontrun{plot_regular_season_rankings(688281863499907072)}
\dontrun{plot_regular_season_rankings(688281863499907072, title = "test", tick_color = "red")}

}
\author{
Nick Bultman, \email{njbultman74@gmail.com}, January 2024
}
\keyword{league}
\keyword{rankings}
\keyword{regular}
\keyword{season}
