% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bout-analysis.R
\name{bout_analysis}
\alias{bout_analysis}
\title{Find "bouts" in categorical time series}
\usage{
bout_analysis(var, data)
}
\arguments{
\item{var}{name of the variable to use from \code{data}}

\item{data}{\link{data.table} containing behavioural variable from or one multiple animals.
When it has a key, unique values, are assumed to represent unique individuals (e.g. in a \link{behavr} table).
Otherwise, it analysis the data as coming from a single animal. \code{data} must have a column \code{t} representing time.}
}
\value{
an object of the same type as \code{data} (i.e. \link[data.table:data.table]{data.table::data.table} or \link[behavr:behavr]{behavr::behavr}).
Each row is a specific bout characterised by three columns.
\itemize{
\item \code{t} -- its \emph{onset}
\item \code{duration} --  its length
\item \code{<var>} -- a column with the same name as \code{var}. The value of \code{var} for this bout.
}
}
\description{
This function is used to find contiguous regions of unique value
in a -- potentially irregular/heterogeneous -- univariate categorical time series.
}
\examples{
# Bout analysis on binary variable:
dt <- toy_dam_data()
dt[, moving := activity > 0]
bdt <- bout_analysis(moving,dt)
print(bdt)
# With multiple states
dt <- toy_ethoscope_data()
# we discretise x position in three states: left, middle and right (1/3 each)
dt[, location := as.character( cut(x,
                               breaks = c(0.0, .33, .67, 1.0),
                               labels = c("left", "middle", "right")))]

bdt <- bout_analysis(location, dt)
}
\references{
\itemize{
\item The relevant \href{https://rethomics.github.io/sleepr}{rethomic tutorial section} -- on sleep analysis
}
}
\seealso{
\itemize{
\item \link{sleep_annotation} -- to generate a binary sleep variable
\item \link{rle} run length encoding function -- on which this analysis is based
}
}
