% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic2ph.R
\name{logistic2ph}
\alias{logistic2ph}
\title{Sieve maximum likelihood estimator (SMLE) for two-phase logistic regression problems}
\usage{
logistic2ph(
  Y_unval = NULL,
  Y = NULL,
  X_unval = NULL,
  X = NULL,
  Z = NULL,
  Bspline = NULL,
  data = NULL,
  hn_scale = 1,
  noSE = FALSE,
  TOL = 1e-04,
  MAX_ITER = 1000,
  verbose = FALSE
)
}
\arguments{
\item{Y_unval}{Column name of the error-prone or unvalidated binary outcome. This argument is required.}

\item{Y}{Column name that stores the validated value of \code{Y_unval} in the second phase. Subjects with missing values of \code{Y} are considered as those not selected in the second phase. This argument is required.}

\item{X_unval}{Specifies the columns of the error-prone covariates. This argument is required.}

\item{X}{Specifies the columns that store the validated values of \code{X_unval} in the second phase. Subjects with missing values of \code{X} are considered as those not selected in the second phase. This argument is required.}

\item{Z}{Specifies the columns of the accurately measured covariates. This argument is optional.}

\item{Bspline}{Specifies the columns of the B-spline basis. This argument is required.}

\item{data}{Specifies the name of the dataset. This argument is required.}

\item{hn_scale}{Specifies the scale of the perturbation constant in the variance estimation. For example, if \code{hn_scale = 0.5}, then the perturbation constant is \eqn{0.5n^{-1/2}}, where \eqn{n} is the first-phase sample size. The default value is \code{1}. This argument is optional.}

\item{noSE}{If \code{TRUE}, then the variances of the parameter estimators will not be estimated. The default value is \code{FALSE}. This argument is optional.}

\item{TOL}{Specifies the convergence criterion in the EM algorithm. The default value is \code{1E-4}. This argument is optional.}

\item{MAX_ITER}{Maximum number of iterations in the EM algorithm. The default number is \code{1000}. This argument is optional.}

\item{verbose}{If \code{TRUE}, then show details of the analysis. The default value is \code{FALSE}.}
}
\value{
\item{coefficients}{Stores the analysis results.}
\item{outcome_err_coefficients}{Stores the outcome error model results.}
\item{Bspline_coefficients}{Stores the final B-spline coefficient estimates.}
\item{covariance}{Stores the covariance matrix of the regression coefficient estimates.}
\item{converge}{In parameter estimation, if the EM algorithm converges, then \code{converge = TRUE}. Otherwise, \code{converge = FALSE}.}
\item{converge_cov}{In variance estimation, if the EM algorithm converges, then \code{converge_cov = TRUE}. Otherwise, \code{converge_cov = FALSE}.}
\item{converge_msg}{In parameter estimation, if the EM algorithm does not converge, then \code{converged_msg} is a string description.}
}
\description{
This function returns the sieve maximum likelihood estimators (SMLE) for the logistic regression model from Lotspeich et al. (2021).
}
\references{
Lotspeich, S. C., Shepherd, B. E., Amorim, G. G. C., Shaw, P. A., & Tao, R. (2021). Efficient odds ratio estimation under two-phase sampling using error-prone data from a multi-national HIV research cohort. \emph{Biometrics, biom.13512.} https://doi.org/10.1111/biom.13512
}
