% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-sequences.R
\name{ts_coalesced}
\alias{ts_coalesced}
\title{Check that all trees in the tree sequence are fully coalesced}
\usage{
ts_coalesced(ts, return_failed = FALSE)
}
\arguments{
\item{ts}{Tree sequence object of the class \code{slendr_ts}}

\item{return_failed}{Report back which trees failed the coalescence
check?}
}
\value{
TRUE or FALSE value if \code{return_failed = FALSE}, otherwise a vector of
(tskit Python 0-based) indices of trees which failed the coalescence test
}
\description{
Check that all trees in the tree sequence are fully coalesced
}
\examples{
\dontshow{check_dependencies(python = TRUE, quit = TRUE) # dependencies must be present
}
init_env()

# load an example model with an already simulated tree sequence
slendr_ts <- system.file("extdata/models/introgression.trees", package = "slendr")
model <- read_model(path = system.file("extdata/models/introgression", package = "slendr"))

# load the tree-sequence object from disk
ts <- ts_load(slendr_ts, model)

ts_coalesced(ts) # is the tree sequence fully coalesced? (TRUE or FALSE)

# returns a vector of tree sequence segments which are not coalesced
not_coalesced <- ts_coalesced(ts, return_failed = TRUE)
}
