% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-sequences.R
\name{ts_fst}
\alias{ts_fst}
\title{Calculate pairwise statistics between sets of individuals}
\usage{
ts_fst(
  ts,
  sample_sets,
  mode = c("site", "branch", "node"),
  windows = NULL,
  span_normalise = TRUE
)
}
\arguments{
\item{ts}{Tree sequence object of the class \code{slendr_ts}}

\item{sample_sets}{A list (optionally a named list) of character vectors with
individual names (one vector per set)}

\item{mode}{The mode for the calculation ("sites" or "branch")}

\item{windows}{Coordinates of breakpoints between windows. The first
coordinate (0) and the last coordinate (equal to \code{ts$sequence_length})
do not have to be specified as they are added automatically.}

\item{span_normalise}{Divide the result by the span of the window? Default
TRUE, see the tskit documentation for more detail.}
}
\value{
For each pairwise calculation, either a single Fst value or a vector
of Fst values (one for each window)
}
\description{
For a discussion on the difference between "site", "branch", and "node"
options of the \code{mode} argument, please see the tskit documentation at
\url{https://tskit.dev/tskit/docs/stable/stats.html#sec-stats-mode}.
}
\examples{
\dontshow{check_dependencies(python = TRUE, quit = TRUE) # dependencies must be present
}
init_env()

# load an example model with an already simulated tree sequence
slendr_ts <- system.file("extdata/models/introgression.trees", package = "slendr")
model <- read_model(path = system.file("extdata/models/introgression", package = "slendr"))

# load the tree-sequence object from disk
ts <- ts_load(slendr_ts, model) \%>\% ts_mutate(mutation_rate = 1e-8, random_seed = 42)

# compute F_st between two sets of individuals in a given tree sequence ts
ts_fst(ts, sample_sets = list(afr = c("AFR_1", "AFR_2", "AFR_3"),
                              eur = c("EUR_1", "EUR_2")))
}
