% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-sequences.R
\name{ts_edges}
\alias{ts_edges}
\title{Extract spatio-temporal edge annotation table from a given tree or tree
sequence}
\usage{
ts_edges(x)
}
\arguments{
\item{x}{Tree object generated by \code{ts_phylo} or a slendr tree sequence
object produced by \code{ts_load}, \code{ts_recapitate},
\code{ts_simplify}, or \code{ts_mutate}}
}
\value{
Data frame of the \code{sf} type containing the times of nodes and
start-end coordinates of edges across space
}
\description{
Extract spatio-temporal edge annotation table from a given tree or tree
sequence
}
\examples{
\dontshow{check_dependencies(python = TRUE, quit = TRUE) # dependencies must be present
}
init_env()

# load an example model with an already simulated tree sequence
slendr_ts <- system.file("extdata/models/introgression.trees", package = "slendr")
model <- read_model(path = system.file("extdata/models/introgression", package = "slendr"))

# load the tree-sequence object from disk
ts <- ts_load(slendr_ts, model)

# extract an annotated table with (spatio-)temporal edge information
ts_edges(ts)
}
