% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_lscape_data}
\alias{get_lscape_data}
\title{Get SLGA landscape data}
\usage{
get_lscape_data(product = NULL, aoi = NULL, write_out = FALSE,
  filedir)
}
\arguments{
\item{product}{Character, one of the options from column 'Short_Name' in
\code{\link[slga:slga_product_info]{slga_product_info}}, where Type =
'Landscape'.}

\item{aoi}{Vector of WGS84 coordinates defining a rectangular area of
interest. The vector may be specified directly in the order xmin, xmax,
ymin, ymax, or the function can derive an aoi from the boundary of an `sf`
or `raster` object.}

\item{write_out}{Boolean, whether to write the retrieved dataset to the
working directory as a GeoTiff. Defaults to FALSE.}

\item{filedir}{directory in which to write files if write_out == TRUE.}
}
\value{
Raster dataset for a single landscape product.
}
\description{
Downloads SLGA gridded landscape data in raster format from public WCS
services.
}
\note{
\itemize{
  \item An aoi larger than 1x1 decimal degree is retrieveable, but be
  aware that download file size will be large. If you want a dataset that
  covers more than ~3x3', it may be faster to download the full
  GeoTIFF from the CSIRO Data Access Portal and crop out your AOI using GDAL.
  \item Output rasters are aligned to the parent dataset rather than the aoi.
  Further resampling may be required for some applications.
  }
}
\examples{
\donttest{
# get slope data for central Brisbane
aoi <- c(152.95, -27.55, 153.07, -27.45)
bne_slope <- get_lscape_data(product = 'SLPPC', aoi = aoi, write_out = FALSE)

# get slope, aspect and relief class data for central Brisbane
bne_SAR <- lapply(c('SLPPC', 'ASPCT', 'RELCL'), function(t) {
  get_lscape_data(product = t, aoi = aoi, write_out = FALSE)
})
}
}
