%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:17:46.
% Do NOT modify this file, instead modify the source (sma/R/Rdisc.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.mat}

\alias{plot.mat}

\title{Red and Green Color Image of Data Matrix}

\description{This function produces a red and green color image of a
data matrix using an RGB color specification. Larger entries are
represented with reds of increasing intensity, and smaller entries
are represented with greens of increasing intensity.  
}

\usage{
plot.mat(x, nrgcols=50, rlabels=F, clabels=F, rcols=1, ccols=1, title="",...)
}

%- maybe also `usage' for other objects documented here.

\arguments{
 \item{x}{a matrix of numbers.}
 \item{nrgcols}{the number of colors (>= 1) to be used in the red
 and green palette.} 
 \item{rlabels}{vector of character strings to be placed at the row
 tickpoints, labels for the rows of \code{X}.} 
 \item{clabels}{vector of character strings to be placed at the
 column tickpoints, labels for the columns of \code{X}.} 
 \item{rcols}{colors to be used for the labels of the rows of
 \code{X}. \code{rcols} can have either length 1, in which case
 all the labels are displayed using the same color, or the same
 length as \code{rlabels}, in which case a color is specified for the
 label of each row of \code{X}.} 
 \item{ccols}{colors to be used for the labels of the columns of
 \code{X}. \code{ccols} can have either length 1, in which case
 all the labels are displayed using the same color, or the same
 length as \code{clabels}, in which case a color is specified for the
 label of each column of \code{X}.} 
 \item{title}{character string, overall title for the plot.}
 \item{\dots}{graphical parameters may also be supplied as arguments  to
          the function (see \code{\link{par}}).  E.g. \code{zlim=c(-3,3)}}
}

%\references{ ~put references to the literature/web site here ~ }


\author{
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu}
}

\seealso{\code{\link{plot.cor}}, \code{\link{rgcolors.func}},
\code{\link{cor.na}}, \code{\link{cor}}, \code{\link{image}},
\code{\link{rgb}}.} 

\examples{
data(MouseArray)
##mouse.setup <- init.grid()
##mouse.data <- init.data() ## see \emph{init.data}
mouse.lratio <- stat.ma(mouse.data, mouse.setup)

## Looking at log ratios of mouse1
plot.mat(spatial.func(mouse.lratio$M[,1], mouse.setup))
}

\keyword{hplot}

%\keyword{Microarray, image of data matrix.} 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
