% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.logrrenv.R
\name{plot.logrrenv}
\alias{plot.logrrenv}
\title{Plots objects  produced by the \code{\link{logrr}} 
function.}
\usage{
\method{plot}{logrrenv}(x, ..., conlist = list(), main = "")
}
\arguments{
\item{x}{An object of class \code{logrrenv}.}

\item{...}{Additional graphical parameters passed to the 
\code{\link[spatstat.geom]{image.im}} function.  See
Details.}

\item{conlist}{Additional argument passed to the 
\code{\link[spatstat.geom]{contour.im}} function.}

\item{main}{A main title for the plot.  Default is blank.}
}
\description{
Plots objects  of class \code{logrrenv} produced by the 
\code{\link{logrr}} function.
}
\details{
An important aspect of this plot is the
  color argument (\code{col}) used for displaying
  the regions outside the non-rejection envelopes.  If NULL
  (the implicit default), then the default color palette
  used by \code{\link[spatstat.geom]{image.im}} will be used. 
  Simpler schemes, e.g., c("blue", "white", "orange") can
  suffice. See the examples.
}
\examples{
data(grave)
logrrsim = logrr(grave, nsim = 9)
plot(logrrsim)
# no border or ribben (legend).  Simple color scheme.
plot(logrrsim, col = c("blue", "white", "orange"), ribbon = FALSE, box = FALSE) 
# alternate color scheme
plot(logrrsim, col = topo.colors(12))
}
\seealso{
\code{\link[spatstat.geom]{plot.im}},
  \code{\link[spatstat.geom]{contour.im}}
}
