% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{get_subgraphs}
\alias{get_subgraphs}
\title{Split a Graph into Subgraphs}
\usage{
get_subgraphs(g, split)
}
\arguments{
\item{g}{the graph (an igraph object)}

\item{split}{a vector with a value for each vertex in \code{g}}
}
\value{
A list of graphs, where each graph is a subgraph of \code{g}
containing the vertices with the same value in \code{split}.
}
\description{
Split a graph into subgraphs using the values in a vector to indicate which
vertices belong together.
}
\examples{
g=igraph::graph_from_literal(1-2,2-3:4,3-4:5:6,5-1)
split=c("A","A","B","B","A","B")
igraph::V(g);split
igraph::V(get_subgraphs(g,split)[[1]])
igraph::V(get_subgraphs(g,split)[[2]])
}
