\name{fitBmme}
\alias{fitBmme}
\title{
Fit a Brownian Motion with Measurement Error
}
\description{
  Given discretely observed animal movement locations, fit a Brownian
  motion model with measurement errors.
}
\usage{
fitBmme(dat, start = NULL, method = "Nelder-Mead", optim.control = list())
}
\arguments{
  \item{dat}{
    a data.frame whose first column is the observation time, and other
    columns are location coordinates.
  }
  \item{start}{
    starting value of the model, a vector of two component, one for
    sigma (sd of BM) and the other for delta (sd for measurement
    error). If unspecified (NULL), a moment estimator will be used
    assuming equal sigma and delta.
  }
  \item{method}{
    the method argument to feed \code{optim}.
  }
  \item{optim.control}{
    a list of control that is passed down to \code{optim}.
  }
}
\details{
  The joint density of the increment data is multivariate normal with a
  sparse (tri-diagonal) covariance matrix. Sparse matrix operation from
  package Matrix is used for computing efficiency in handling large
  data. 
}
\value{
  A list of the following components:
  \item{estimate }{the esimated parameter vector}
  \item{var.est }{variance matrix of the estimator}
  \item{loglik }{loglikelihood evaluated at the estimate}
  \item{convergence}{convergence code from optim}
}
\references{
  Pozdnyakov V., Meyer, TH., Wang, Y., and Yan, J. (2013)
  On modeling animal movements using Brownian motion with measurement
  error. Ecology doi:doi:10.1890/13-0532.1.
}
\author{
  Jun Yan <jun.yan@uconn.edu>
}
\seealso{
  \code{\link{fitMovRes}}
}
\examples{
set.seed(123)

tgrid <- seq(0, 500, by = 1)
dat <- rbmme(tgrid, sigma = 1, delta = 0.5)

fit <- fitBmme(dat)
fit
}
\keyword{models}
