% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{vcov}
\alias{vcov}
\alias{vcov.smam_mrme}
\alias{vcov.smam_mm}
\alias{vcov.smam_mrh}
\alias{vcov.smam_mr}
\alias{vcov.smam_bmme}
\title{Variance-Covariance Matrix of smam Estimators}
\usage{
\method{vcov}{smam_mrme}(
  object,
  nBS = 25,
  detailBS = TRUE,
  numThreads = 5,
  gradMethod = "simple",
  vcovMethod = "pBootstrap",
  integrControl = integr.control(),
  ...
)

\method{vcov}{smam_mm}(
  object,
  nBS = 25,
  detailBS = TRUE,
  numThreads = 5,
  integrControl = integr.control(),
  ...
)

\method{vcov}{smam_mrh}(object, numThreads = 5, integrControl = integr.control(), ...)

\method{vcov}{smam_mr}(object, ...)

\method{vcov}{smam_bmme}(object, ...)
}
\arguments{
\item{object}{a fitted object from one of `smam::fitXXXX` functions}

\item{nBS}{number of bootstrap.}

\item{detailBS}{whether or not output estimation results of bootstrap,
which can be used to generate bootstrap CI. Required
when `vcovMethod=='pBootstrap'`.}

\item{numThreads}{the number of threads for parallel computation.
If its value is greater than 1, then parallel computation will be
processed. Otherwise, serial computation will be processed.}

\item{gradMethod}{method used for numeric gradient (\code{numDeriv::grad}).
Required when `vcovMethod=='Godambe'`.}

\item{vcovMethod}{method of calculating variance covariance matrix.
This should be one of `pBootstrap` (default) and `Godambe`.}

\item{integrControl}{a list of control parameters for the \code{integrate}
function: rel.tol, abs.tol, subdivision.}

\item{...}{Optional arguments that are not used}
}
\description{
This function calculates variance covariance matrix for
estimators from smam package. Different methods will
be used for different `smam` models.
}
\examples{
## time consuming example
#tgrid <- seq(0, 100, length=100)
#set.seed(123)
#dat <- rMRME(tgrid, 1, 0.5, 1, 0.01, "m")

## fit whole dataset to the MRME model
#fit <- fitMRME(dat, start=c(1, 0.5, 1, 0.01))
#fit

## get covariance matrix of estimators
#vcov(fit)

}
