% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R
\name{normalize}
\alias{normalize}
\title{Normalization wrapper}
\usage{
normalize(dataset, method, exclude = NULL, ...)
}
\arguments{
\item{dataset}{we want to perform normalization on}

\item{method}{selected method of normalization}

\item{exclude}{\code{character}. Vector of attributes to exclude from the
normalization}

\item{...}{Further arguments for \code{method}}
}
\value{
The normalized dataset
}
\description{
Normalization wrapper
}
\examples{
library("smartdata")

super_iris <- normalize(iris, method = "min_max", exclude = "Species", by = "column")
# Use default parameter by = "row"
super_iris <- normalize(iris, method = "min_max", exclude = c("Sepal.Length", "Species"))
super_iris <- normalize(iris, method = "min_max", exclude = "Species", by = "row")
super_iris <- normalize(iris, method = "z_score", exclude = "Species", by = "row")
super_iris <- normalize(iris, method = "sd_quotient", exclude = "Species", by = "row")

}
