% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.scaling}
\alias{smbinning.scaling}
\title{Scaling}
\usage{
smbinning.scaling(logitraw, pdo = 20, score = 720, odds = 99)
}
\arguments{
\item{logitraw}{Logistic regression (glm) that must have specified \code{family=binomial} and 
whose variables have been generated with \code{smbinning.gen} or \code{smbinning.factor.gen}.}

\item{pdo}{Points to double the oods.}

\item{score}{Score at which the desire \code{odds} occur.}

\item{odds}{Desired \code{odds} at the selected \code{score}.}
}
\value{
A scaled model from a logistic regression built with binned variables, the parameters
used in the scaling process, the expected minimum and maximum score, and the original logistic model.
}
\description{
It transforms the coefficients of a logistic regression into scaled points
based on the following three parameters pre-selected by the analyst: PDO, Score, and Odds.
}
\examples{
# Training and testing samples (Just some basic formality for Modeling)
pop=chileancredit # Set population
train=subset(pop,Rnd<=0.7) # Training sample
test=subset(pop,Rnd>0.7) # Testing sample
rm(chileancredit) # Remove original dataset

# Generate binned variables
smbCuScore3=smbinning(train,x="CuScore3",y="FlagGB")
smbCuTOB=smbinning(train,x="CuTOB",y="FlagGB")
smbCuDpBal=smbinning(train,x="CuDpBal",y="FlagGB")
smbCuDDFq12M=smbinning(train,x="CuDDFq12M",y="FlagGB")
smbCuPOSFq12M=smbinning(train,x="CuPOSFq12M",y="FlagGB")
smbCuWealth=smbinning.factor.custom(
  train,x="CuWealth",y="FlagGB",
  c("'W01','W02'","'W03','W04','W05'","'W06','W07','W08','W09','W10'"))
  
# Update dataset
pop=smbinning.gen(pop,smbCuScore3,"g1CuScore3")
pop=smbinning.gen(pop,smbCuTOB,"g1CuTOB")
pop=smbinning.gen(pop,smbCuDpBal,"g1CuDpBal")
pop=smbinning.gen(pop,smbCuDDFq12M,"g1CuDDFq12M")
pop=smbinning.gen(pop,smbCuPOSFq12M,"g1CuPOSFq12M")
pop=smbinning.factor.gen(pop,smbCuWealth,"g1CuWealth")
# Resampling
train=subset(pop,Rnd<=0.7) # Training sample
test=subset(pop,Rnd>0.7) # Testing sample

# Run logistic regression
f=FlagGB~g1CuScore3+g1CuTOB+g1CuDpBal+g1CuDDFq12M+g1CuPOSFq12M+g1CuWealth
modlogisticsmb=glm(f,data = train,family = binomial())
summary(modlogisticsmb)

# Scaling: From logistic parameters to points
smbscaled=smbinning.scaling(modlogisticsmb,pdo=20,score=720,odds=99)
smbscaled$logitscaled # Scaled model
smbscaled$minmaxscore # Expected minimum and maximum Score
smbscaled$parameters # Parameters used for scaling
smbscaled$logitraw # Extract of original logistic regression
}
