% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sai.R
\name{AI}
\alias{AI}
\alias{ai}
\alias{ai_var}
\title{Areal Interpolation}
\usage{
ai(source, target, vars)

ai_var(source, target, vars, vars_var, sc_vars = FALSE, var_method = "CS")
}
\arguments{
\item{source}{a \code{sf} object - source spatial data.}

\item{target}{a \code{sf} object - target spatial data.}

\item{vars}{a \code{character} representing the variables (observed at the
source) to be estimated at the target data.}

\item{vars_var}{a scalar of type \code{character} representing the name of
the variable in the source dataset that stores the variances of the
variable to be estimated at the target data.}

\item{sc_vars}{boolean indicating whether \code{vars} should be scaled by its
observed variance (if available).}

\item{var_method}{a \code{character} representing the method to approximate
the variance of the AI estimates. Possible values are "CS"
(Cauchy-Schwartz) or "MI" (Moran's I).}
}
\value{
the target (of type \code{sf}) with estimates of the variables
observed at the source data.
}
\description{
This function estimates variables observed at a "source" region
into a "target" region. "Source" and "target" regions represent two
different ways to divide a city, for example. For more details, see
\url{https://lcgodoy.me/smile/articles/sai.html}.
}
\examples{
data(nyc_surv)
data(nyc_comd)

## creating variables that store the variance for each area
## this is done to exemplify the functionality of the package
nyc_surv <- transform(nyc_surv,
                      my_var = moe / qnorm(p = .975))
nyc_surv <- transform(nyc_surv, my_var = my_var * my_var)

\dontrun{
## areal interpolation
estimate_comd <-
   ai(source = nyc_surv, target = nyc_comd,
      vars = "estimate")

## areal interpolation with uncertainty estimation
estimate_comd <-
   ai_var(source = nyc_surv, target = nyc_comd,
          vars = "estimate", vars_var = "my_var",
          var_method = "MI")
}

}
