% Generated by roxygen2 (4.0.2): do not edit by hand
\name{cardinalBasis_ceschino}
\alias{cardinalBasis_ceschino}
\title{Cardinal Basis for cubic Ceschino interpolation}
\usage{
cardinalBasis_ceschino(x, xout, cubic = TRUE, deriv = 0)
}
\arguments{
\item{x}{Numeric vector of design points.}

\item{xout}{Numeric vector giving new points.}

\item{cubic}{Logical. Use cubic interpolation or basic linear?}

\item{deriv}{Integer or logical. Compute the derivative?}
}
\value{
A list with the following elements

\item{x}{

Numeric vector of abscissas at which the basis is evaluated. This
is a copy of \code{xout}.

}
\item{CB}{

Matrix of the Cardinal Basis function values.

}
\item{deriv, cubic}{

Copy of input.

}
\item{method}{

Character description of the method involved in the CB determination.

}
}
\description{
Cardinal Basis for cubic Ceschino interpolation.
}
\details{
This is a simple and raw interface to \code{alterp} Fortran
subroutine.
}
\note{
This function does not allow extrapolation, so an error will
result when \code{xout} contains element outside of the range of
\code{x}.
}
\examples{
set.seed(123)
n <- 16L; nout <- 300L
x <- sort(runif(n))

## let 'xout' contain n + nout points including nodes
xout <- sort(c(x, runif(nout, min = x[1], max = x[n])))
y <- sin(2 * pi * x)
res  <- cardinalBasis_ceschino(x, xout = xout, deriv = 0)

matplot(res$x, res$CB, type = "n", main = "Cardinal Basis")
abline(v = x, h = 1.0, col = "gray")
points(x = x, y = rep(0, n), pch = 21, col = "black",
       lwd = 2, bg = "white")
matlines(res$x, res$CB, type = "l")

## interpolation error should be fairly small
max(abs(sin(2 * pi * xout) - res$CB \\\%*\\\% y))
}
\author{
Alain Hebert for Fortran code.

Yves Deville for R interface.
}
\seealso{
\code{\link{interp_ceschino}} for the related interpolation
function, \code{\link{cardinalBasis_natSpline}} and \code{\link{cardinalBasis_lagrange}}
for other Cardinal Basis constructions.
}

