% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterFunctionByTags.R
\name{filterFunctionsByTags}
\alias{filterFunctionsByTags}
\title{Get a list of implemented test functions with specific tags.}
\usage{
filterFunctionsByTags(tags, or = FALSE)
}
\arguments{
\item{tags}{[\code{character}]\cr
Character vector of tags. All available tags can be determined with a call
to \code{\link{getAvailableTags}}.}

\item{or}{[\code{logical(1)}]\cr
Should all \code{tags} be assigned to the function or are single tags allowed
as well?
Default is \code{FALSE}.}
}
\value{
[\code{character}]
  Named vector of function names with the given tags.
}
\description{
Get a list of implemented test functions with specific tags.
}
\examples{
# list all functions which are unimodal
filterFunctionsByTags("unimodal")
# list all functions which are both unimodal and separable
filterFunctionsByTags(c("unimodal", "separable"))
# list all functions which are unimodal or separable
filterFunctionsByTags(c("multimodal", "separable"), or = TRUE)
}

