% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adam-gum.R, R/autogum.R, R/gum.R
\name{gum}
\alias{gum}
\alias{auto.gum}
\alias{gum_old}
\alias{ges}
\title{Generalised Univariate Model}
\usage{
gum(data, orders = c(1, 1), lags = c(1, frequency(data)),
  type = c("additive", "multiplicative"), formula = NULL,
  regressors = c("use", "select", "adapt", "integrate"),
  initial = c("backcasting", "optimal", "complete"), persistence = NULL,
  transition = NULL, measurement = rep(1, sum(orders)),
  loss = c("likelihood", "MSE", "MAE", "HAM", "MSEh", "TMSE", "GTMSE",
  "MSCE"), h = 0, holdout = FALSE, bounds = c("admissible", "none"),
  silent = TRUE, model = NULL, ...)

auto.gum(data, orders = 3, lags = frequency(data), type = c("additive",
  "multiplicative", "select"), formula = NULL, regressors = c("use",
  "select", "adapt", "integrate"), initial = c("backcasting", "optimal",
  "complete"), ic = c("AICc", "AIC", "BIC", "BICc"), loss = c("likelihood",
  "MSE", "MAE", "HAM", "MSEh", "TMSE", "GTMSE", "MSCE"), h = 0,
  holdout = FALSE, bounds = c("admissible", "none"), silent = TRUE, ...)

gum_old(data, orders = c(1, 1), lags = c(1, frequency(y)),
  type = c("additive", "multiplicative"), persistence = NULL,
  transition = NULL, measurement = rep(1, sum(orders)),
  initial = c("optimal", "backcasting"), loss = c("likelihood", "MSE",
  "MAE", "HAM", "MSEh", "TMSE", "GTMSE", "MSCE"), h = 10, holdout = FALSE,
  bounds = c("restricted", "admissible", "none"), silent = c("all",
  "graph", "legend", "output", "none"), ...)

ges(...)
}
\arguments{
\item{data}{Vector, containing data needed to be forecasted. If a matrix (or
data.frame / data.table) is provided, then the first column is used as a
response variable, while the rest of the matrix is used as a set of explanatory
variables. \code{formula} can be used in the latter case in order to define what
relation to have.}

\item{orders}{Order of the model. Specified as vector of number of states
with different lags. For example, \code{orders=c(1,1)} means that there are
two states: one of the first lag type, the second of the second type.
In case of \code{auto.gum()}, this parameters is the value of the max order
to check.}

\item{lags}{Defines lags for the corresponding orders. If, for example,
\code{orders=c(1,1)} and lags are defined as \code{lags=c(1,12)}, then the
model will have two states: the first will have lag 1 and the second will
have lag 12. The length of \code{lags} must correspond to the length of
\code{orders}. In case of the \code{auto.gum()}, the value of the maximum
lag to check. This should usually be a maximum frequency of the data.}

\item{type}{Type of model. Can either be \code{"additive"} or
\code{"multiplicative"}. The latter means that the GUM is fitted on
log-transformed data. In case of \code{auto.gum()}, can also be \code{"select"},
implying automatic selection of the type.}

\item{formula}{Formula to use in case of explanatory variables. If \code{NULL},
then all the variables are used as is. Can also include \code{trend}, which would add
the global trend. Only needed if \code{data} is a matrix or if \code{trend} is provided.}

\item{regressors}{The variable defines what to do with the provided explanatory
variables:
\code{"use"} means that all of the data should be used, while
\code{"select"} means that a selection using \code{ic} should be done,
\code{"adapt"} will trigger the mechanism of time varying parameters for the
explanatory variables.}

\item{initial}{Can be either character or a vector of initial states. If it
is character, then it can be \code{"optimal"}, meaning that the initial
states are optimised, \code{"backcasting"}, meaning that the initials are
produced using backcasting procedure (still estimating initials for explanatory
variables), or \code{"complete"}, meaning backcasting for all states.}

\item{persistence}{Persistence vector \eqn{g}, containing smoothing
parameters. If \code{NULL}, then estimated.}

\item{transition}{Transition matrix \eqn{F}. Can be provided as a vector.
Matrix will be formed using the default \code{matrix(transition,nc,nc)},
where \code{nc} is the number of components in the state vector. If
\code{NULL}, then estimated.}

\item{measurement}{Measurement vector \eqn{w}. If \code{NULL}, then
estimated.}

\item{loss}{The type of Loss Function used in optimization. \code{loss} can
be:
\itemize{
\item \code{likelihood} - the model is estimated via the maximisation of the
likelihood of the function specified in \code{distribution};
\item \code{MSE} (Mean Squared Error),
\item \code{MAE} (Mean Absolute Error),
\item \code{HAM} (Half Absolute Moment),
\item \code{LASSO} - use LASSO to shrink the parameters of the model;
\item \code{RIDGE} - use RIDGE to shrink the parameters of the model;
\item \code{TMSE} - Trace Mean Squared Error,
\item \code{GTMSE} - Geometric Trace Mean Squared Error,
\item \code{MSEh} - optimisation using only h-steps ahead error,
\item \code{MSCE} - Mean Squared Cumulative Error.
}
In case of LASSO / RIDGE, the variables are not normalised prior to the estimation,
but the parameters are divided by the mean values of explanatory variables.

Note that model selection and combination works properly only for the default
\code{loss="likelihood"}.

Furthermore, just for fun the absolute and half analogues of multistep estimators
are available: \code{MAEh}, \code{TMAE}, \code{GTMAE}, \code{MACE},
\code{HAMh}, \code{THAM}, \code{GTHAM}, \code{CHAM}.

Last but not least, user can provide their own function here as well, making sure
that it accepts parameters \code{actual}, \code{fitted} and \code{B}. Here is an
example:

\code{lossFunction <- function(actual, fitted, B) return(mean(abs(actual-fitted)))}

\code{loss=lossFunction}}

\item{h}{The forecast horizon. Mainly needed for the multistep loss functions.}

\item{holdout}{Logical. If \code{TRUE}, then the holdout of the size \code{h}
is taken from the data (can be used for the model testing purposes).}

\item{bounds}{The type of bounds for the parameters to use in the model
estimation. Can be either \code{admissible} - guaranteeing the stability of the
model, or \code{none} - no restrictions (potentially dangerous).}

\item{silent}{Specifies, whether to provide the progress of the function or not.
If \code{TRUE}, then the function will print what it does and how much it has
already done.}

\item{model}{A previously estimated GUM model, if provided, the function
will not estimate anything and will use all its parameters.}

\item{...}{Other non-documented parameters. See \link[smooth]{adam} for
details.  However, there are several unique parameters passed to the optimiser
in comparison with \code{adam}:
1. \code{algorithm0}, which defines what algorithm to use in nloptr for the initial
optimisation. By default, this is "NLOPT_LN_BOBYQA".
2. \code{algorithm} determines the second optimiser. By default this is
"NLOPT_LN_NELDERMEAD".
3. maxeval0 and maxeval, that determine the number of iterations for the two
optimisers. By default, \code{maxeval0=1000}, \code{maxeval=40*k}, where
k is the number of estimated parameters.
4. xtol_rel0 and xtol_rel, which are 1e-8 and 1e-6 respectively.
There are also ftol_rel0, ftol_rel, ftol_abs0 and ftol_abs, which by default
are set to values explained in the \code{nloptr.print.options()} function.}

\item{ic}{The information criterion to use in the model selection.}
}
\value{
Object of class "adam" is returned with similar elements to the
\link[smooth]{adam} function.
}
\description{
Function constructs Generalised Univariate Model, estimating matrices F, w,
vector g and initial parameters.
}
\details{
The function estimates the Single Source of Error state space model of the
following type:

\deqn{y_{t} = w_t' v_{t-l} + \epsilon_{t}}

\deqn{v_{t} = F v_{t-l} + g_{t} \epsilon_{t}}

where \eqn{v_{t}} is the state vector (defined using \code{orders}) and
\eqn{l} is the vector of \code{lags}, \eqn{w_t} is the \code{measurement}
vector (which includes fixed elements and explanatory variables),
\eqn{F} is the \code{transition} matrix, \eqn{g_t} is the \code{persistence}
vector (includes explanatory variables as well if provided), finally,
\eqn{\epsilon_{t}} is the error term.

For some more information about the model and its implementation, see the
vignette: \code{vignette("gum","smooth")}
}
\examples{
gum(BJsales, h=8, holdout=TRUE)

\donttest{ourModel <- gum(rnorm(118,100,3), orders=c(2,1), lags=c(1,4), h=18, holdout=TRUE)}

# Redo previous model on a new data and produce prediction interval
\donttest{gum(rnorm(118,100,3), model=ourModel, h=18)}

# Produce something crazy with optimal initials (not recommended)
\donttest{gum(rnorm(118,100,3), orders=c(1,1,1), lags=c(1,3,5), h=18, holdout=TRUE, initial="o")}

# Simpler model estimated using trace forecast error loss function and its analytical analogue
\donttest{gum(rnorm(118,100,3), orders=c(1), lags=c(1), h=18, holdout=TRUE, bounds="n", loss="TMSE")}


x <- rnorm(50,100,3)

# The best GUM model for the data
ourModel <- auto.gum(x, orders=2, lags=4, h=18, holdout=TRUE)

\donttest{summary(ourModel)}

}
\references{
\itemize{
\item Svetunkov I. (2023) Smooth forecasting with the smooth package in R. arXiv:2301.01790.
\doi{10.48550/arXiv.2301.01790}.
\item Svetunkov I. (2015 - Inf) "smooth" package for R - series of posts about the underlying
models and how to use them: \url{https://openforecast.org/category/r-en/smooth/}.
}

\itemize{
\item Snyder, R. D., 1985. Recursive Estimation of Dynamic Linear Models.
Journal of the Royal Statistical Society, Series B (Methodological) 47 (2), 272-276.
\item Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
Forecasting with exponential smoothing: the state space approach,
Springer-Verlag. \doi{10.1007/978-3-540-71918-2}.
}
}
\seealso{
\code{\link[smooth]{adam}, \link[smooth]{es}, \link[smooth]{ces}}

\code{\link[smooth]{gum}, \link[smooth]{es},
\link[smooth]{ces}, \link[smooth]{sim.es}, \link[smooth]{ssarima}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.com}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
