\name{dst2.plot}
\alias{dst2.plot}
\title{
Plot of bivariate skew-\eqn{t} density function
}
\description{
Produces a contour plot of the density function of a bivariate 
skew-\eqn{t} variate.
}
\usage{dst2.plot(x, y, xi, Omega, alpha, df, dp = NULL, ...) }

\arguments{
\item{x}{
vector of values of the first component.
}
\item{y}{
vector of values of the second component.
}
\item{xi}{
a vector of length 2 containing the location parameter.
}
\item{Omega}{
a 2 by 2 matrix containing a covariance matrix.
}
\item{alpha}{
a vector of length 2 containing the shape parameter.
}
\item{df}{
a positive number, representing the degrees of freedom .
}
\item{dp}{
  a list with components named \code{xi, Omega, alpha, df}, containing
  quantities as described above. If this parameter is set, then the
  individual parameters must not be.
  }
\item{...}{
additional parameters to be passed to \code{contour}.
}}
\value{
A list containing the original input parameters plus a matrix
containing the density function evaluated at the grid formed 
by the \code{x} and \code{y} values. 
}
\details{Typical usages are
\preformatted{%
dst2.plot(x, y, xi, Omega, alpha, df, ...)
dst2.plot(x, y, dp=, ...)
}
  The density function is evalutate at the grid of points whose
  coordinates are given by vectors \code{x} and \code{y}.
  The actual computation is done by the  function \code{dmst}.
  A contour level plot is produced on the graphical window. 
}

\section{Background}{
The family of multivariate skew-t distributions is an extension of the 
multivariate Student's \eqn{t} family, via the introduction of a \code{shape} 
parameter which regulates skewness; when \code{shape=0}, the skew-\eqn{t}
distribution reduces to the usual \eqn{t} distribution. 
When \code{df=Inf} the distribution reduces to the multivariate skew-normal 
one; see \code{dmsn}. See the reference below for additional information.
}
\references{
Azzalini, A. and Capitanio, A. (2003).
  Distributions generated by perturbation of symmetry 
  with emphasis on a multivariate skew \eqn{t} distribution.
  \emph{J.Roy. Statist. Soc. B} \bold{65}, 367--389.
}
\seealso{
\code{\link{dmst}}, \code{\link{dsn2.plot}}
}
\examples{
x <- y <- seq(-5, 5, length=35)
dst2.plot(x, y, c(-1,2), diag(c(1,2.5)), c(2,-3), df=5)
}
\keyword{distribution}

