% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caseconverters.R
\name{caseconverter}
\alias{caseconverter}
\alias{to_snake_case}
\alias{to_lower_camel_case}
\alias{to_upper_camel_case}
\alias{to_screaming_snake_case}
\alias{to_parsed_case}
\alias{to_mixed_case}
\alias{to_lower_upper_case}
\alias{to_upper_lower_case}
\title{Specific case converter shortcuts}
\usage{
to_snake_case(string, preprocess = NULL, replace_special_characters = NULL,
  postprocess = NULL, prefix = "", postfix = "", unique_sep = NULL,
  empty_fill = NULL, parsing_option = 1, abbreviations = NULL)

to_lower_camel_case(string, preprocess = NULL,
  replace_special_characters = NULL, postprocess = NULL, prefix = "",
  postfix = "", unique_sep = NULL, empty_fill = NULL,
  parsing_option = 1, abbreviations = NULL)

to_upper_camel_case(string, preprocess = NULL,
  replace_special_characters = NULL, postprocess = NULL, prefix = "",
  postfix = "", unique_sep = NULL, empty_fill = NULL,
  parsing_option = 1, abbreviations = NULL)

to_screaming_snake_case(string, preprocess = NULL,
  replace_special_characters = NULL, postprocess = NULL, prefix = "",
  postfix = "", unique_sep = NULL, empty_fill = NULL,
  parsing_option = 1, abbreviations = NULL)

to_parsed_case(string, preprocess = NULL, replace_special_characters = NULL,
  postprocess = NULL, prefix = "", postfix = "", unique_sep = NULL,
  empty_fill = NULL, parsing_option = 1, abbreviations = NULL)

to_mixed_case(string, preprocess = NULL, replace_special_characters = NULL,
  postprocess = NULL, prefix = "", postfix = "", unique_sep = NULL,
  empty_fill = NULL, parsing_option = 1, abbreviations = NULL)

to_lower_upper_case(string, preprocess = NULL,
  replace_special_characters = NULL, postprocess = NULL, prefix = "",
  postfix = "", unique_sep = NULL, empty_fill = NULL,
  parsing_option = 1, abbreviations = NULL)

to_upper_lower_case(string, preprocess = NULL,
  replace_special_characters = NULL, postprocess = NULL, prefix = "",
  postfix = "", unique_sep = NULL, empty_fill = NULL,
  parsing_option = 1, abbreviations = NULL)
}
\arguments{
\item{string}{A string (for example names of a data frame).}

\item{preprocess}{A string (if not \code{NULL}) that will be wrapped internally
into \code{stringr::regex()}. All matches will be replaced by underscores. Underscores can later turned into another separator via \code{postprocess}.}

\item{replace_special_characters}{A character vector (if not \code{NULL}). The entries of this argument
need to be elements of \code{stringi::stri_trans_list()} (like "Latin-ASCII", which is often useful) or names of lookup tables (currently
only "german" is supported). In the order of the entries the letters of the input
 string will be transliterated via \code{stringi::stri_trans_general()} or replaced via the 
 matches of the lookup table.

You should use this feature with care in case of \code{case = "parsed"} and 
\code{case = "none"}, since for upper case letters, which have transliterations/replacements
 of length 2, the second letter will be transliterated to lowercase, for example Oe, Ae, Ss, which
 might not always be what is intended.}

\item{postprocess}{String that will be used as separator. The defaults are \code{"_"} 
and \code{""}, regarding the specified \code{case}.}

\item{prefix}{prefix (string).}

\item{postfix}{postfix (string).}

\item{unique_sep}{A string. If not \code{NULL}, then duplicated names will get 
a suffix integer
in the order of their appearance. The suffix is separated by the supplied string
 to this argument.}

\item{empty_fill}{A string. If it is supplied, then each entry that matches "" will be replaced
by the supplied string to this argument.}

\item{parsing_option}{An integer that will determine the parsing_option.
#' \itemize{
 \item{1: \code{RRRStudio -> RRR_Studio}}
 \item{2: \code{RRRStudio -> RRRS_tudio}}
 \item{3: parses at the beginning like option 1 and the rest like option 2.}
 \item{4: parses at the beginning like option 2 and the rest like option 1.}
 \item{5: parses like option 1 but suppresses "_" around non special characters.
 In this way case conversion won't apply after these characters. See examples.}
 \item{any other integer <= 0: no parsing"}
 }}

\item{abbreviations}{character with (uppercase) abbreviations. This marks
abbreviations with an underscore behind (in front of the parsing).
useful if parsinoption 1 is needed, but some abbreviations need parsing_option 2.}
}
\value{
A character vector according the specified parameters above.

A character vector according the specified target case.
}
\description{
Wrappers around \code{to_any_case()}
}
\note{
caseconverters are vectorised over \code{postprocess}, \code{prefix} and \code{postfix}.
\code{postprocess} might follow in the future.
}
\examples{
strings <- c("this Is a Strange_string", "AND THIS ANOTHER_One", NA)

to_snake_case(strings)
to_lower_camel_case(strings)
to_upper_camel_case(strings)
to_screaming_snake_case(strings)
to_lower_upper_case(strings)
to_upper_lower_case(strings)
to_parsed_case(strings)
to_mixed_case(strings)


}
\seealso{
\href{https://github.com/Tazinho/snakecase}{snakecase on github}, \code{\link{to_any_case}} for flexible high level conversion.
}
\author{
Malte Grosser, \email{malte.grosser@gmail.com}

Malte Grosser, \email{malte.grosser@gmail.com}
}
\keyword{utilities}
