% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk_pars.R
\name{sk_pars}
\alias{sk_pars}
\title{Initialize Kronecker covariance function parameters for a sk grid}
\usage{
sk_pars(g, pars = "gau", fill = "initial")
}
\arguments{
\item{g}{list, a sk grid list (or any other object accepted by \code{sk})}

\item{pars}{character or list defining kernels accepted by \code{sk_pars_make}}

\item{fill}{character, either 'initial', 'lower' or 'upper'}
}
\value{
a list defining the Kronecker covariance parameters
}
\description{
Returns a parameter list defining the Kronecker covariance model for \code{g}, with
default initial values assigned to parameters based on the grid dimensions and sample
variance of observed data.
}
\details{
Swap \code{fill='initial'} with 'lower' and 'upper' to get default lower and upper bounds.
}
\examples{
sk_pars(g=10)
sk_pars(c(10,15))
sk_pars(c(10,15), 'mat')
sk_pars(c(10,15), 'mat', 'upper')
}
\seealso{
sk sk_corr

Other parameter managers: 
\code{\link{sk_bds}()},
\code{\link{sk_fit}()},
\code{\link{sk_kp}()},
\code{\link{sk_pars_make}()},
\code{\link{sk_pars_update}()},
\code{\link{sk_to_string}()}
}
\concept{parameter managers}
