% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk_plot.R
\name{sk_plot_pars}
\alias{sk_plot_pars}
\title{Plot the covariance structure of a snapKrig model}
\usage{
sk_plot_pars(pars, g = NULL, simple = FALSE, ...)
}
\arguments{
\item{pars}{list of the form returned by \code{sk_pars} with entries 'y', 'x', ('eps', 'psill')}

\item{g}{any object understood by \code{sk}}

\item{simple}{logical, if FALSE the function adds some annotation}

\item{...}{additional arguments passed to \code{sk_plot}}
}
\value{
the same as \code{sk_plot}
}
\description{
Visualization of the footprint of a covariance kernel as a heatmap of approximate
size \code{dim(g)}, where each grid cell is colored according to its covariance with
the central grid point.
}
\details{
If \code{g} is not supplied, the function sets a default with dimensions 100 x 100.
A default resolution is computed such that the maximum nugget-free covariance along
the outer edge of the plot is 5\% of \code{pars$psill}.

When \code{simple=FALSE} (the default), covariance parameters are printed in the
title and axis labels with values rounded to 3 decimal places. This can be
customized by passing arguments 'main', 'ylab', 'xlab' (and any others
accepted \code{sk_plot} apart from \code{gdim}).
}
\examples{
gdim = c(100, 100)
g = sk(gdim)
pars = sk_pars(g, 'mat')

# plot with default grid
sk_plot_pars(pars)

# plot with a predefined grid
sk_plot_pars(pars, g)

# zoom in/out by passing a grid object with suitably modified resolution
gres = g[['gres']]
sk_plot_pars(pars, sk(gdim=gdim, gres=0.5*gres))
sk_plot_pars(pars, sk(gdim=gdim, gres=2*gres))

# change plot style settings (all parameters of sk_plot accepted)
sk_plot_pars(pars, simple=TRUE)
sk_plot_pars(pars, minimal=TRUE)

}
\seealso{
sk sk_pars

Other plotting functions: 
\code{\link{sk_plot}()}
}
\concept{plotting functions}
