% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumulative.R
\name{cumulativeScores}
\alias{cumulativeScores}
\alias{cumulativelyDominates}
\title{Cumulative scores}
\usage{
cumulativeScores(powerRelation, elements = NULL)

cumulativelyDominates(powerRelation, e1, e2, strictly = FALSE)
}
\arguments{
\item{powerRelation}{A \code{PowerRelation} object created by \code{\link[=newPowerRelation]{newPowerRelation()}}}

\item{elements}{vector of elements of which to calculate their scores.
If \code{elements == NULL}, create vectors for all elements in \code{pr$elements}}

\item{e1, e2}{Elements in \code{powerRelation$elements}}

\item{strictly}{If TRUE, check if \code{p1} \emph{strictly} dominates \code{p2}}
}
\value{
Score function returns a list of type \code{CumulativeScores} and length of \code{powerRelation$elements}
(unless parameter \code{elements} is specified).
Each index contains a vector of length \code{powerRelation$equivalenceClasses}, cumulatively counting up the number of
times the given element appears in each equivalence class.

\code{cumulativelyDominates()} returns \code{TRUE} if \code{e1} cumulatively dominates \code{e2}.
}
\description{
Calculate cumulative score vectors for each element.
}
\details{
\loadmathjax
An element's cumulative score vector is calculated by cumulatively adding up the
amount of times it appears in each equivalence class in the \code{powerRelation}. E.g. in a linear power relation with
eight coalitions, if element 1 appears in coalitions placed at 1, 3, and 6,
its score vector is [1, 1, 2, 2, 2, 3, 3, 3].
}
\section{Dominance}{


\mjseqn{i} dominates \mjseqn{j} if for each index
\mjeqn{x, \textrm{Score}(i)_x \geq \textrm{Score}(j)_x}{x, Score(i)_x >= Score(j)_x}.

\mjseqn{i} \emph{strictly} dominates \mjseqn{j}, if additionally
\mjeqn{\textrm{Score}(i) \neq \textrm{Score}(j)}{Score(i) != Score(j)}.
}

\examples{
pr <- newPowerRelationFromString("12 > 1 > 2", asWhat = as.numeric)

# `1`: c(1, 2, 2)
# `2`: c(1, 1, 2)
cumulativeScores(pr)

# calculate for selected number of elements
cumulativeScores(pr, c(2))

# TRUE
d1 <- cumulativelyDominates(pr, 1, 2)

# TRUE
d2 <- cumulativelyDominates(pr, 1, 1)

# FALSE
d3 <- cumulativelyDominates(pr, 1, 1, strictly = TRUE)

stopifnot(all(d1, d2, !d3))

}
\references{
\insertRef{2015Cumulative}{socialranking}

\insertRef{2017axiomaticAndAlgorithmicPerspectives}{socialranking}
}
\seealso{
Other score vector functions: 
\code{\link{copelandScores}()},
\code{\link{kramerSimpsonScores}()},
\code{\link{lexcelScores}()},
\code{\link{ordinalBanzhafScores}()}
}
\concept{score vector functions}
