% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PowerRelation.R
\name{coalitionsAreIndifferent}
\alias{coalitionsAreIndifferent}
\title{Are coalitions indifferent}
\usage{
coalitionsAreIndifferent(powerRelation, c1, c2)
}
\arguments{
\item{powerRelation}{A \code{\link{PowerRelation}} object created by \code{\link[=PowerRelation]{PowerRelation()}} or \code{\link[=as.PowerRelation]{as.PowerRelation()}}}

\item{c1}{Coalition \link[base:c]{vector}}

\item{c2}{Coalition \link[base:c]{vector}}
}
\value{
Logical value \code{TRUE} if \code{c1} and \code{c2} are in the same equivalence class, else \code{FALSE}.
}
\description{
Check if coalitions are indifferent to one another, or, in other words, if they appear in the same equivalence class.
}
\examples{
pr <- PowerRelation(list(list(c(1,2)), list(1, 2)))

stopifnot(coalitionsAreIndifferent(pr, c(1,2), c(1)) == FALSE)
stopifnot(coalitionsAreIndifferent(pr, 2, 1) == TRUE)

# Note that it doesn't fail with non-existing power relations
stopifnot(coalitionsAreIndifferent(pr, 1, c()) == FALSE)
stopifnot(coalitionsAreIndifferent(pr, 3, c(1,2,3)) == TRUE)

}
\seealso{
Other lookup functions: 
\code{\link{elementLookup}()},
\code{\link{equivalenceClassIndex}()}
}
\concept{lookup functions}
