% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadratic_plateau.R
\name{quadratic_plateau}
\alias{quadratic_plateau}
\alias{QP_f}
\alias{SS_QP}
\title{Quadratic-plateau response function}
\usage{
QP_f(x, intercept, slope, Xc)

SS_QP(x, intercept, slope, Xc)

quadratic_plateau(
  data = NULL,
  stv,
  ry,
  target = NULL,
  tidy = FALSE,
  plot = FALSE,
  resid = FALSE
)
}
\arguments{
\item{x}{selfstart vector for independent variable, Default: NULL}

\item{intercept}{selfstart arg. for intercept Default: NULL}

\item{slope}{selfstart arg. for slope Default: NULL}

\item{Xc}{selfstart arg. for critical value Default: NULL}

\item{data}{Optional argument to call and object of type data.frame or data.table
containing the stv and ry data, Default: NULL}

\item{stv}{name of the vector containing soil test values (-) of type \code{numeric}.}

\item{ry}{name of the vector containing relative yield values (\%) of type \code{numeric}.}

\item{target}{\code{numeric} value of relative yield target (e.g. 90 for 90\%) to estimate the CSTV.
The target needs to be < plateau, otherwise, target = plateau.}

\item{tidy}{logical operator (TRUE/FALSE) to decide the type of return. TRUE returns a data.frame, FALSE returns a list (default).}

\item{plot}{logical operator (TRUE/FALSE) to plot the quadratic-plateau model, Default: FALSE}

\item{resid}{logical operator (TRUE/FALSE) to plot residuals analysis, Default: FALSE}
}
\value{
returns an object of type \code{ggplot} if plot = TRUE.

returns a residuals plot if resid = TRUE.

returns an object of class \code{data.frame} if tidy = TRUE,

returns an object of class \code{list} if tidy = FALSE.

QP_f: vector of the same length as x using the quadratic-plateau function

SS_QP: selfStart object to pass into the quadratic_plateau fit

quadratic_plateau: function
}
\description{
This function helps to fit a quadratic-plateau response model and to
estimate a critical soil test values (CSTV) above which yield response becomes flat.
}
\details{
See \href{https://adriancorrendo.github.io/soiltestcorr/articles/quadratic_plateau_tutorial.html}{online-documentation} for additional details.
}
\note{
For extended reference, we recommend to visit
\url{https://gradcylinder.org/quad-plateau/} & \url{https://github.com/austinwpearce/SoilTestCocaCola}
by Austin Pearce.
Self-start function code adapted from nlraa package by F. Miguez \url{https://github.com/femiguez/nlraa}
}
\examples{
\donttest{
# Example dataset
 dat <- data.frame("ry" = c(65,80,85,88,90,94,93,96,97,95,98,100,99,99,100),
                   "stv" = c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15))
 # Run
 fit_example_qp <- quadratic_plateau(data = dat, 
 ry = ry, stv = stv, resid = TRUE, plot = FALSE)
 fit_example_qp
}
}
\references{
Bullock, D.G. and Bullock, D.S. (1994)
Quadratic and Quadratic-Plus-Plateau Models for Predicting Optimal Nitrogen Rate of Corn: A Comparison.
\emph{Agron. J., 86: 191-195.} \doi{10.2134/agronj1994.00021962008600010033x}
}
\seealso{
\code{\link[rlang]{eval_tidy}},\code{\link[rlang]{defusing-advanced}}
\code{\link[minpack.lm]{nlsLM}}
\code{\link[stats]{AIC}},\code{\link[stats]{lm}},\code{\link[stats]{optim}},\code{\link[stats]{coef}},\code{\link[stats]{predict}}
\code{\link[AICcmodavg]{AICc}}
\code{\link[modelr]{model-quality}}
\code{\link[nlstools]{nlsResiduals}}
\code{\link[dplyr]{bind}}
\code{\link[ggplot2]{ggplot}},\code{\link[ggplot2]{aes}},\code{\link[ggplot2]{geom_rug}},\code{\link[ggplot2]{geom_point}},\code{\link[ggplot2]{geom_abline}},\code{\link[ggplot2]{geom_path}},\code{\link[ggplot2]{annotate}},\code{\link[ggplot2]{labs}},\code{\link[ggplot2]{theme}}
\code{\link[ggpp]{annotate}}
}
