% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isolationForest_r6.R
\docType{data}
\name{isolationForest}
\alias{isolationForest}
\title{Fit an Isolation Forest}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
isolationForest
}
\description{
'solitude' class implements the isolation forest method
  introduced by paper Isolation based Anomaly Detection (Liu, Ting and Zhou
  <doi:10.1145/2133360.2133363>). The extremely randomized trees (extratrees)
  required to build the isolation forest is grown using
  \code{\link[ranger]{ranger}} function from \pkg{ranger} package.
}
\section{Design}{
 \code{$new()} initiates a new 'solitude' object. The
  possible arguments are:

  \itemize{

  \item \code{sample_size}: (positive integer, default = 256) Number of
  observations in the dataset to used to build a tree in  the forest

  \item \code{num_trees}: (positive integer, default = 100) Number of trees
  to be built in the forest

  \item \code{mtry}: (positive integer, default = 1) Number of variables to
  be selected at each node of a tree. Random cut points are chosen for each
  variable and most optimal among them is chosen

  \item \code{replace}: (boolean, default = FALSE) Whether the sample of
  observations should be chosen with replacement when sample_size is less
  than the number of observations in the dataset

  \item \code{seed}: (positive integer, default = 101) Random seed for the
  forest

  \item \code{nproc}: (NULL or a positive integer, default: NULL, means use
  all resources) Number of parallel threads to be used by ranger

  \item \code{respect_unordered_factors}: (string, default: "partition")See
  respect.unordered.factors argument in \code{\link[ranger]{ranger}}

  }

  \code{$fit()} fits a isolation forest for the given dataframe, computes
  depths of terminal nodes of each tree and stores the anomaly scores and
  average depth values in \code{$scores} object as a data.table

  \code{$predict()} returns anomaly scores for a new data as a data.table
}

\section{Details}{


  \itemize{

  \item Parallelization: \code{\link[ranger]{ranger}} is parallelized and by
  default uses all the resources. This is supported when nproc is set to
  NULL. The process of obtaining depths of terminal nodes (which is excuted
  with \code{$fit()} is called) may be parallelized separately by setting up
  a \pkg{future} backend.

  }
}

\examples{
data("attrition", package = "rsample")
set.seed(1)
index = sample(ceiling(nrow(attrition) * 0.2))
isf = isolationForest$new()  # initiate
isf$fit(attrition[index, ])  # fit on 80\% data
isf$scores                   # obtain anomaly scores

# scores closer to 1 might indicate outliers
plot(density(isf$scores$anomaly_score))
round(head(sort(isf$scores$anomaly_score, dec = TRUE), 20), 2)

isf$predict(attrition[-index, ]) # scores for new data
}
\keyword{datasets}
