% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_soundgen.R
\name{reportTime}
\alias{reportTime}
\title{Report time}
\usage{
reportTime(i, nIter, time_start, jobs = NULL)
}
\arguments{
\item{i}{current iteration}

\item{nIter}{total number of iterations}

\item{time_start}{time when the loop started running}

\item{jobs}{vector of length \code{nIter} specifying the relative difficulty
of each iteration. If not NULL, estimated time left takes into account
whether the jobs ahead will take more or less time than the jobs already
completed}
}
\description{
Internal soundgen function.
}
\details{
Based on the current iteration, total number of iterations, and time when the
loop started running, prints estimated time left or a summary upon
completion.
}
\examples{
time_start = proc.time()
for (i in 1:5) {
  Sys.sleep(i ^ 2 / 100)
  soundgen:::reportTime(i = i, nIter = 5, time_start = time_start, jobs = (1:5) ^ 2 / 10)
}
}
\keyword{internal}
