% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_soundgen.R
\name{flatEnv}
\alias{flatEnv}
\title{Flat envelope}
\usage{
flatEnv(sound, windowLength = 200, samplingRate = 16000, method = c("hil",
  "rms", "peak")[1], windowLength_points = NULL, killDC = FALSE,
  dynamicRange = 80, plot = FALSE)
}
\arguments{
\item{sound}{input vector oscillating about zero}

\item{windowLength}{the length of smoothing window, ms}

\item{samplingRate}{the sampling rate, Hz. Only needed if the length of
smoothing window is specified in ms rather than points}

\item{method}{'hil' for Hilbert envelope, 'rms' for root mean square
amplitude, 'peak' for peak amplitude per window}

\item{windowLength_points}{the length of smoothing window, points. If
specified, overrides both \code{windowLength} and \code{samplingRate}}

\item{killDC}{if TRUE, dynamically removes DC offset or similar deviations of
average waveform from zero}

\item{dynamicRange}{parts of sound quieter than \code{-dynamicRange} dB will
not be amplified}

\item{plot}{if TRUE, plots the original sound, smoothed envelope, and
flattened sound}
}
\description{
Flattens the amplitude envelope of a waveform. This is achieved by dividing
the waveform by some function of its smoothed rolling amplitude (peak or root
mean square).
}
\examples{
a = rnorm(500) * seq(1, 0, length.out = 500)
b = flatEnv(a, plot = TRUE, killDC = TRUE,
            windowLength_points = 5)         # too short
c = flatEnv(a, plot = TRUE, killDC = TRUE,
            windowLength_points = 250)       # too long
d = flatEnv(a, plot = TRUE, killDC = TRUE,
            windowLength_points = 50)        # about right

\dontrun{
s = soundgen(sylLen = 1000, ampl = c(0, -40, 0), plot = TRUE, osc = TRUE)
# playme(s)
s_flat = flatEnv(s, plot = TRUE, windowLength = 50)
# playme(s_flat)
}
}
