% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSM.R
\name{ssm}
\alias{ssm}
\title{Self-similarity matrix}
\usage{
ssm(x, samplingRate = NULL, windowLength = 40, overlap = 75,
  step = NULL, ssmWin = 40, maxFreq = NULL, nBands = NULL,
  MFCC = 2:13, input = c("mfcc", "audiogram", "spectrum")[1],
  norm = FALSE, simil = c("cosine", "cor")[1],
  returnSSM = "deprecated", kernelLen = 200, kernelSD = 0.2,
  padWith = 0, plot = TRUE, heights = c(2, 1),
  specPars = list(levels = seq(0, 1, length = 30), colorTheme = c("bw",
  "seewave", "heat.colors", "...")[2], xlab = "Time, s", ylab = "kHz", ylim
  = c(0, maxFreq/1000)), ssmPars = list(levels = seq(0, 1, length = 30),
  colorTheme = c("bw", "seewave", "heat.colors", "...")[2], xlab =
  "Time, s", ylab = "Time, s", main = "Self-similarity matrix"),
  noveltyPars = list(type = "b", pch = 16, col = "black", lwd = 3))
}
\arguments{
\item{x}{path to a .wav file or a vector of amplitudes with specified
samplingRate}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector, rather than a .wav file)}

\item{windowLength}{length of FFT window, ms}

\item{overlap}{overlap between successive FFT frames, \%}

\item{step}{you can override \code{overlap} by specifying FFT step, ms}

\item{ssmWin}{window for averaging SSM, ms}

\item{maxFreq}{highest band edge of mel filters, Hz. Defaults to
\code{samplingRate / 2}. See \code{\link[tuneR]{melfcc}}}

\item{nBands}{number of warped spectral bands to use. Defaults to \code{100 *
windowLength / 20}. See \code{\link[tuneR]{melfcc}}}

\item{MFCC}{which mel-frequency cepstral coefficients to use; defaults to
\code{2:13}}

\item{input}{either MFCCs ("cepstrum") or mel-filtered spectrum ("audiogram")}

\item{norm}{if TRUE, the spectrum of each STFT frame is normalized}

\item{simil}{method for comparing frames: "cosine" = cosine similarity, "cor"
= Pearson's correlation}

\item{returnSSM}{if TRUE, returns the SSM}

\item{kernelLen}{length of checkerboard kernel for calculating novelty, ms
(larger values favor global vs. local novelty)}

\item{kernelSD}{SD of checkerboard kernel for calculating novelty}

\item{padWith}{how to treat edges when calculating novelty: NA = treat sound
before and after the recording as unknown, 0 = treat it as silence}

\item{plot}{if TRUE, plots the SSM}

\item{heights}{relative sizes of the SSM and spectrogram/novelty plot}

\item{specPars}{graphical parameters passed to \code{filled.contour.mod} and
affecting the \code{\link{spectrogram}}}

\item{ssmPars}{graphical parameters passed to \code{filled.contour.mod} and
affecting the plot of SSM}

\item{noveltyPars}{graphical parameters passed to
\code{\link[graphics]{lines}} and affecting the novelty contour}
}
\value{
If \code{returnSSM} is TRUE, returns a list of two components: $ssm
  contains the self-similarity matrix, and $novelty contains the novelty
  vector.
}
\description{
Calculates the self-similarity matrix and novelty vector of a sound.
}
\examples{
sound = c(soundgen(), soundgen(nSyl = 4, sylLen = 50, pauseLen = 70,
          formants = NA, pitch = c(500, 330)))
# playme(sound)
ssm(sound, samplingRate = 16000,
         input = 'audiogram', simil = 'cor', norm = FALSE,
         ssmWin = 10, kernelLen = 150)  # detailed, local features
\dontrun{
m = ssm(sound, samplingRate = 16000,
         input = 'mfcc', simil = 'cosine', norm = TRUE,
         ssmWin = 50, kernelLen = 600,  # global features
         specPars = list(colorTheme = 'heat.colors'),
         ssmPars = list(colorTheme = 'bw'),
         noveltyPars = list(type = 'l', lty = 3, lwd = 2))
# plot(m$novelty, type='b')  # use for peak detection, etc
}
}
\references{
\itemize{
  \item El Badawy, D., Marmaroli, P., & Lissek, H. (2013). Audio
  Novelty-Based Segmentation of Music Concerts. In Acoustics 2013 (No.
  EPFL-CONF-190844)
  \item Foote, J. (1999, October). Visualizing music and
  audio using self-similarity. In Proceedings of the seventh ACM
  international conference on Multimedia (Part 1) (pp. 77-80). ACM.
  \item
  Foote, J. (2000). Automatic audio segmentation using a measure of audio
  novelty. In Multimedia and Expo, 2000. ICME 2000. 2000 IEEE International
  Conference on (Vol. 1, pp. 452-455). IEEE.
  }
}
\seealso{
\code{\link{spectrogram}} \code{\link{modulationSpectrum}}
  \code{\link{segment}}

\code{\link{spectrogram}} \code{\link{modulationSpectrum}}
}
