% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.R
\name{segmentFolder}
\alias{segmentFolder}
\title{Segment all files in a folder}
\usage{
segmentFolder(
  myfolder,
  htmlPlots = TRUE,
  shortestSyl = 40,
  shortestPause = 40,
  sylThres = 0.9,
  interburst = NULL,
  interburstMult = 1,
  burstThres = 0.075,
  peakToTrough = 3,
  troughLeft = TRUE,
  troughRight = FALSE,
  windowLength = 40,
  overlap = 80,
  summary = TRUE,
  plot = FALSE,
  savePlots = FALSE,
  savePath = NA,
  verbose = TRUE,
  reportEvery = 10,
  col = "green",
  xlab = "Time, ms",
  ylab = "Amplitude",
  main = NULL,
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  sylPlot = list(lty = 1, lwd = 2, col = "blue"),
  burstPlot = list(pch = 8, cex = 3, col = "red"),
  ...
)
}
\arguments{
\item{myfolder}{full path to target folder}

\item{htmlPlots}{if TRUE, saves an html file with clickable plots}

\item{shortestSyl}{minimum acceptable length of syllables, ms}

\item{shortestPause}{minimum acceptable break between syllables, ms.
Syllables separated by less time are merged. To avoid merging, specify
\code{shortestPause = NA}}

\item{sylThres}{amplitude threshold for syllable detection (as a
proportion of global mean amplitude of smoothed envelope)}

\item{interburst}{minimum time between two consecutive bursts (ms). If
specified, it overrides \code{interburstMult}}

\item{interburstMult}{multiplier of the default minimum interburst
interval (median syllable length or, if no syllables are detected, the same
number as \code{shortestSyl}). Only used if \code{interburst} is
not specified. Larger values improve detection of unusually broad shallow
peaks, while smaller values improve the detection of sharp narrow peaks}

\item{burstThres}{to qualify as a burst, a local maximum has to be at least
\code{burstThres} times the height of the global maximum of amplitude
envelope}

\item{peakToTrough}{to qualify as a burst, a local maximum has to be at
least \code{peakToTrough} times the local minimum on the LEFT over
analysis window (which is controlled by \code{interburst} or
\code{interburstMult})}

\item{troughLeft}{should local maxima be compared to the trough
on the left and/or right of it? Default to TRUE and FALSE, respectively}

\item{troughRight}{should local maxima be compared to the trough
on the left and/or right of it? Default to TRUE and FALSE, respectively}

\item{windowLength}{length (ms) and overlap (%) of the smoothing
window used to produce the amplitude envelope, see
\code{\link[seewave]{env}}}

\item{overlap}{length (ms) and overlap (%) of the smoothing
window used to produce the amplitude envelope, see
\code{\link[seewave]{env}}}

\item{summary}{if TRUE, returns only a summary of the number and spacing of
syllables and vocal bursts. If FALSE, returns a list containing full stats
on each syllable and bursts (location, duration, amplitude, ...)}

\item{plot}{if TRUE, produces a segmentation plot}

\item{savePlots}{if TRUE, saves plots as .png files}

\item{savePath}{full path to the folder in which to save the plots. Defaults
to NA}

\item{verbose, reportEvery}{if TRUE, reports progress every \code{reportEvery}
files and estimated time left}

\item{col}{main plotting parameters}

\item{xlab}{main plotting parameters}

\item{ylab}{main plotting parameters}

\item{main}{main plotting parameters}

\item{width}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{height}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{units}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{res}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{sylPlot}{a list of graphical parameters for displaying the syllables}

\item{burstPlot}{a list of graphical parameters for displaying the bursts}

\item{...}{other graphical parameters passed to \code{\link[graphics]{plot}}}
}
\value{
If \code{summary} is TRUE, returns a dataframe with one row per audio
  file. If \code{summary} is FALSE, returns a list of detailed descriptives.
}
\description{
Finds syllables and bursts in all .wav files in a folder.
}
\details{
This is just a convenient wrapper for \code{\link{segment}} intended for
analyzing the syllables and bursts in a large number of audio files at a
time. In verbose mode, it also reports ETA every ten iterations. With default
settings, running time should be about a second per minute of audio.
}
\examples{
\dontrun{
# Download 260 sounds from the supplements to Anikin & Persson (2017) at
# http://cogsci.se/publications.html
# unzip them into a folder, say '~/Downloads/temp'
myfolder = '~/Downloads/temp'  # 260 .wav files live here
s = segmentFolder(myfolder, verbose = TRUE, savePlot = TRUE)

# Check accuracy: import a manual count of syllables (our "key")
key = segmentManual  # a vector of 260 integers
trial = as.numeric(s$nBursts)
cor(key, trial, use = 'pairwise.complete.obs')
boxplot(trial ~ as.integer(key), xlab='key')
abline(a=0, b=1, col='red')
}
}
\seealso{
\code{\link{segment}}
}
