% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_math.R
\name{getIntegerRandomWalk}
\alias{getIntegerRandomWalk}
\title{Discrete random walk}
\usage{
getIntegerRandomWalk(
  rw,
  nonlinBalance = 50,
  minLength = 50,
  q1 = NULL,
  q2 = NULL,
  plot = FALSE
)
}
\arguments{
\item{rw}{a random walk generated by \code{\link{getRandomWalk}} (expected
range 0 to 100)}

\item{nonlinBalance}{a number between 0 to 100: 0 = returns all zeros;
100 = returns all twos}

\item{minLength}{the mimimum length of each epoch}

\item{q1, q2}{cutoff points for transitioning from regime 0 to 1 (q1) or from
regime 1 to 2 (q2). See noiseThresholdsDict for defaults}

\item{plot}{if TRUE, plots the random walk underlying nonlinear regimes}
}
\value{
Returns a vector of integers (0/1/2) of the same length as rw.
}
\description{
Takes a continuous random walk and converts it to continuous epochs of
repeated values 0/1/2, each at least minLength points long. 0/1/2 correspond
to different noise regimes: 0 = no noise, 1 = subharmonics, 2 = subharmonics
and jitter/shimmer.
}
\examples{
rw = getRandomWalk(len = 100, rw_range = 100, rw_smoothing = .2)
r = getIntegerRandomWalk(rw, nonlinBalance = 75,
                         minLength = 10, plot = TRUE)
r = getIntegerRandomWalk(rw, nonlinBalance = 15,
                         q1 = 30, q2 = 70,
                         minLength = 10, plot = TRUE)
}
