% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postprocessing.R
\name{reverb}
\alias{reverb}
\title{Reverb & echo}
\usage{
reverb(
  x,
  samplingRate = NULL,
  echoDelay = 200,
  echoLevel = -20,
  reverbDelay = 70,
  reverbSpread = 130,
  reverbLevel = -25,
  reverbDensity = 50,
  reverbType = "gaussian",
  filter = list(),
  dynamicRange = 80,
  output = c("audio", "detailed")[1],
  play = FALSE,
  reportEvery = NULL,
  cores = 1,
  saveAudio = NULL
)
}
\arguments{
\item{x}{path to a folder, one or more wav or mp3 files c('file1.wav',
'file2.mp3'), Wave object, numeric vector, or a list of Wave objects or
numeric vectors}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector)}

\item{echoDelay}{the delay at which the echo appears, ms}

\item{echoLevel}{the rate at which the echo weakens at each repetition, dB}

\item{reverbDelay}{the time of maximum reverb density, ms}

\item{reverbSpread}{standard deviation of reverb spread around time
\code{reverbDelay}, ms}

\item{reverbLevel}{the maximum amplitude of reverb, dB below input}

\item{reverbDensity}{the number of echos or "voices" added}

\item{reverbType}{so far only "gaussian" has been implemented}

\item{filter}{(optional) a spectral filter to apply to the created reverb and
echo (see \code{addFormants} for acceptable formats)}

\item{dynamicRange}{the precision with which the reverb and echo are
calculated, dB}

\item{output}{"audio" = returns just the processed audio, "detailed" =
returns a list with reverb window, the added reverb/echo, etc.}

\item{play}{if TRUE, plays the processed audio}

\item{reportEvery}{when processing multiple inputs, report estimated time
left every ... iterations (NULL = default, NA = don't report)}

\item{cores}{number of cores for parallel processing}

\item{saveAudio}{full (!) path to folder for saving the processed audio; NULL
= don't save, '' = same as input folder (NB: overwrites the originals!)}
}
\description{
Adds reverberation and/or echo to a sound. Algorithm for reverb: adds
time-shifted copies of the signal weighted by a decay function, which is
analogous to convoluting the input with a parametric model of some
hypothetical impulse response function. In simple terms: we specify how much
and when the sound rebounds back (as from a wall) and add these time-shifted
copies to the original, optionally with some spectral filtering.
}
\examples{
s = soundgen()
s_rev = reverb(s, 16000)
# playme(s_rev)

\dontrun{
# double echo, no reverb
s1 = reverb(s, samplingRate = 16000, reverbLevel = NULL,
            echoDelay = c(250, 800), echoLevel = c(-15, -25))
# playme(s1)
# spectrogram(s1, 16000, osc = TRUE, ylim = c(0, 4))

# only reverb (indoors)
s2 = reverb(s, samplingRate = 16000, echoDelay = NULL,
            reverbDelay = 70, reverbSpread = 130,
            reverbLevel = -20, reverbDensity = 20)
# playme(s2)
# spectrogram(s2, 16000, osc = TRUE, ylim = c(0, 4))

# reverb (caves)
s3 = reverb(s, samplingRate = 16000, echoDelay = NULL,
            reverbDelay = 600, reverbSpread = 1500,
            reverbLevel = -10, reverbDensity = 100)
# playme(s3)
# spectrogram(s3, 16000, osc = TRUE, ylim = c(0, 4))

# both echo and reverb with high frequencies emphasized
s4 = reverb(s, samplingRate = 16000,
            echoDelay = 250, echoLevel = -20,
            reverbDelay = 70, reverbSpread = 120,
            reverbLevel = -25, reverbDensity = 50,
            filter = list(formants = NULL, lipRad = 3))
# playme(s4)
# spectrogram(s4, 16000, osc = TRUE, ylim = c(0, 4))

# add reverb to a recording
s5 = reverb('~/Downloads/temp260/ut_fear_57-m-tone.wav',
            echoDelay = 850, echoLevel = -40)
# playme(s5, 44100)

# add reverb to all files in a folder, save the result
reverb('~/Downloads/temp2', saveAudio = '~/Downloads/temp2/rvb')
}
}
