% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smap.R
\name{smap}
\alias{smap}
\alias{smap,sf-method}
\alias{smap,SpatRaster-method}
\title{smap forecast}
\usage{
\S4method{smap}{sf}(
  data,
  column,
  target,
  lib = NULL,
  pred = NULL,
  E = 3,
  tau = 1,
  k = E + 2,
  theta = c(0, 1e-04, 3e-04, 0.001, 0.003, 0.01, 0.03, 0.1, 0.3, 0.5, 0.75, 1, 1.5, 2, 3,
    4, 6, 8),
  nb = NULL,
  threads = detectThreads(),
  detrend = TRUE
)

\S4method{smap}{SpatRaster}(
  data,
  column,
  target,
  lib = NULL,
  pred = NULL,
  E = 3,
  tau = 1,
  k = E + 2,
  theta = c(0, 1e-04, 3e-04, 0.001, 0.003, 0.01, 0.03, 0.1, 0.3, 0.5, 0.75, 1, 1.5, 2, 3,
    4, 6, 8),
  threads = detectThreads(),
  detrend = TRUE
)
}
\arguments{
\item{data}{observation data.}

\item{column}{name of library variable.}

\item{target}{name of target variable.}

\item{lib}{(optional) libraries indices.}

\item{pred}{(optional) predictions indices.}

\item{E}{(optional) embedding dimensions.}

\item{tau}{(optional) step of spatial lags.}

\item{k}{(optional) number of nearest neighbors used.}

\item{theta}{(optional) weighting parameter for distances.}

\item{nb}{(optional) neighbours list.}

\item{threads}{(optional) number of threads to use.}

\item{detrend}{(optional) whether to remove the linear trend.}
}
\value{
A list
\describe{
\item{\code{xmap}}{forecast performance}
\item{\code{varname}}{name of target variable}
\item{\code{method}}{method of cross mapping}
}
}
\description{
smap forecast
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg", package="spEDM"))
\donttest{
smap(columbus,"inc","crime",E = 5,k = 6)
}
}
\references{
Sugihara G. 1994. Nonlinear forecasting for the classification of natural time series. Philosophical Transactions: Physical Sciences and Engineering, 348 (1688):477-495.
}
